/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.qosgroups;

import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.ConfPageController;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.impl.qosgroups.QosValidationTask;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.admin.view.qosgroups.QOSGroupsSubpageView;
import com.intel.stl.ui.admin.view.qosgroups.QOSGsEditorPanel;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class QOSGroupsPageController
extends ConfPageController<QOSGroup, QOSGsEditorPanel> {
    private Set<String> reserved;

    public QOSGroupsPageController(String name, String description, ImageIcon icon, QOSGroupsSubpageView view) {
        super(name, description, icon, view);
    }

    @Override
    protected String getHelpID() {
        return HelpAction.getInstance().getQOSGroupMgmt();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        super.setContext(context, observer);
        this.edtCtr.setContext(context);
        this.reserved = this.mgtApi.getReservedQOSGroups();
    }

    @Override
    public void onEnter() {
        if (this.mgtApi != null && this.mgtApi.isConfigReady() && !this.mgtApi.supportQOSGroup()) {
            QOSGroupsSubpageView view = (QOSGroupsSubpageView)this.getView();
            view.showMessageCard(UILabels.STL81060_QOSG_UNAVAILABLE.getDescription());
            return;
        }
        super.onEnter();
    }

    @Override
    protected ArrayList<Item<QOSGroup>> initData() throws Exception {
        List<QOSGroup> qosGroups = this.mgtApi.getQOSGroups();
        ArrayList<Item<QOSGroup>> res = new ArrayList<Item<QOSGroup>>();
        if (qosGroups != null) {
            for (QOSGroup app : qosGroups) {
                boolean isEditable = this.isEditable(app);
                Item<QOSGroup> item = new Item<QOSGroup>(res.size(), app.getName(), app, isEditable);
                item.setState(ChangeState.NONE);
                res.add(item);
            }
        }
        return res;
    }

    protected boolean isEditable(QOSGroup app) {
        String name = app.getName();
        return !this.reserved.contains(name);
    }

    @Override
    protected QOSGroup getCopy(QOSGroup obj) {
        return obj.copy();
    }

    @Override
    protected QOSGroup createObj() {
        return new QOSGroup();
    }

    @Override
    protected void removeItemObject(String name) throws Exception {
        this.mgtApi.removeQOSGroup(name);
    }

    @Override
    protected ValidationTask<QOSGroup> getValidationTask(ValidationDialog dialog, Item<QOSGroup> item) {
        QosValidationTask task = new QosValidationTask(dialog, this.valModel, this.orgItems, item, this.mgtApi);
        return task;
    }

    @Override
    protected void saveItemObject(String oldName, QOSGroup obj) throws Exception {
        if (oldName != null) {
            this.mgtApi.updateQOSGroup(oldName, obj);
        } else {
            this.mgtApi.addQOSGroup(obj);
        }
    }
}

