/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.qosgroups;

import com.intel.stl.ui.admin.impl.IRendererModel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.qosgroups.MulticastSLRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.BandwidthRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.BaseSLRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.FlowControlDisableRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.HighPriorityRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.HoqLifeRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PktLifeTimeMultRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PreemptRankRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.RespSLRenderer;
import java.util.LinkedHashMap;
import java.util.Map;

public class QosGroupRendererModel
implements IRendererModel {
    private static final Map<String, Class<? extends IAttrRenderer<?>>> map = new LinkedHashMap<String, Class<? extends IAttrRenderer<?>>>(){
        private static final long serialVersionUID = 4668173857239402969L;
        {
            this.put("HighPriority", HighPriorityRenderer.class);
            this.put("Bandwidth", BandwidthRenderer.class);
            this.put("PktLifeTimeMult", PktLifeTimeMultRenderer.class);
            this.put("BaseSL", BaseSLRenderer.class);
            this.put("RespSL", RespSLRenderer.class);
            this.put("MulticastSL", MulticastSLRenderer.class);
            this.put("FlowControlDisable", FlowControlDisableRenderer.class);
            this.put("PreemptRank", PreemptRankRenderer.class);
            this.put("HoqLife", HoqLifeRenderer.class);
        }
    };
    private String[] qosNames;

    public void setQosNames(String[] qosNames) {
        this.qosNames = qosNames;
    }

    public String[] updateQosName(String oldName, String newName) {
        for (int i = 0; i < this.qosNames.length; ++i) {
            if (!this.qosNames[i].equals(oldName)) continue;
            this.qosNames[i] = newName;
            break;
        }
        return this.qosNames;
    }

    @Override
    public String[] getRendererNames() {
        return map.keySet().toArray(new String[0]);
    }

    @Override
    public IAttrRenderer<?> getRenderer(String name) throws Exception {
        Class<IAttrRenderer<?>> klass = map.get(name);
        if (klass != null) {
            IAttrRenderer<?> res = klass.newInstance();
            return res;
        }
        throw new IllegalArgumentException("Unknown renderer '" + name + "'");
    }
}

