/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.qosgroups;

import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.api.management.virtualfabrics.BaseSL;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.ValidationItem;
import com.intel.stl.ui.common.ValidationModel;
import java.util.List;

public class QosValidationTask
extends ValidationTask<QOSGroup> {
    private final IManagementApi mgmtApi;

    public QosValidationTask(ValidationDialog dialog, ValidationModel<QOSGroup> model, List<Item<QOSGroup>> items, Item<QOSGroup> toCheck, IManagementApi mgmtApi) {
        super(dialog, model, items, toCheck);
        this.mgmtApi = mgmtApi;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        ValidationItem<QOSGroup> vi;
        if (this.toCheck.getState() == ChangeState.NONE) {
            return 0;
        }
        int count = 0;
        if (this.toCheck.getState() == ChangeState.UPDATE || this.toCheck.getState() == ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2124_NAME_CHECK.getValue() + "...");
            vi = this.uniqueNameCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        if (this.toCheck.getState() == ChangeState.UPDATE || this.toCheck.getState() == ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2173_BASESL_CHECK.getValue() + "...");
            vi = this.uniqueBaseSLCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        return count;
    }

    protected ValidationItem<QOSGroup> uniqueNameCheck(Item<QOSGroup> app) {
        long id = app.getId();
        String name = app.getObj().getName();
        for (Item item : this.items) {
            if (item.getId() == id || !((QOSGroup)item.getObj()).getName().equals(name)) continue;
            return new ValidationItem<QOSGroup>(STLConstants.K2124_NAME_CHECK.getValue(), UILabels.STL81001_DUP_NAME.getDescription(), UILabels.STL81002_DUP_NAME_SUG.getDescription());
        }
        return null;
    }

    protected ValidationItem<QOSGroup> uniqueBaseSLCheck(Item<QOSGroup> qos) {
        long id = qos.getId();
        BaseSL baseSL = qos.getObj().getBaseSL();
        if (baseSL != null) {
            for (Item item : this.items) {
                if (!baseSL.equals(((QOSGroup)item.getObj()).getBaseSL()) || item.getId() == id) continue;
                return new ValidationItem<QOSGroup>(STLConstants.K2173_BASESL_CHECK.getValue(), UILabels.STL81012_DUP_BASESL.getDescription(), UILabels.STL81013_DUP_BASESL_SUG.getDescription());
            }
        }
        return null;
    }
}

