/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.virtualfabrics;

import com.intel.stl.api.management.virtualfabrics.ApplicationName;
import com.intel.stl.api.management.virtualfabrics.PKey;
import com.intel.stl.api.management.virtualfabrics.QOSGroupName;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.ValidationItem;
import com.intel.stl.ui.common.ValidationModel;
import java.util.List;

public class VFValidationTask
extends ValidationTask<VirtualFabric> {
    private static final String VF_APPLICATION_ALL = "All";

    public VFValidationTask(ValidationDialog dialog, ValidationModel<VirtualFabric> model, List<Item<VirtualFabric>> items, Item<VirtualFabric> toCheck) {
        super(dialog, model, items, toCheck);
    }

    @Override
    protected Integer doInBackground() throws Exception {
        VirtualFabric vf;
        PKey pkey;
        if (this.toCheck.getState() == ChangeState.NONE) {
            return 0;
        }
        int count = 0;
        if (this.toCheck.getState() == ChangeState.UPDATE || this.toCheck.getState() == ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2124_NAME_CHECK.getValue() + "...");
            ValidationItem<VirtualFabric> vi = this.uniqueNameCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        if ((pkey = (vf = (VirtualFabric)this.toCheck.getObj()).getPKey()) != null) {
            List<ApplicationName> apps = vf.getApplications();
            boolean appAllSpecified = false;
            for (ApplicationName app : apps) {
                if (!VF_APPLICATION_ALL.equals(app.getValue())) continue;
                appAllSpecified = true;
                break;
            }
            if (appAllSpecified && (Short)pkey.getObject() != Short.MAX_VALUE) {
                ValidationItem vi = new ValidationItem(STLConstants.K2162_PKEY_CHECK.getValue(), UILabels.STL81010_APPLICATIONS_ALL.getDescription(), UILabels.STL81011_APPLICATIONS_ALL_SUG.getDescription());
                this.publish(vi);
                ++count;
            }
        }
        if (this.toCheck.getState() == ChangeState.UPDATE || this.toCheck.getState() == ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2162_PKEY_CHECK.getValue() + "...");
            QOSGroupName qos = vf.getQosGroup();
            if (qos != null && pkey == null) {
                ValidationItem vi = new ValidationItem(STLConstants.K2162_PKEY_CHECK.getValue(), UILabels.STL81014_REQUIRE_PKEY.getDescription(), UILabels.STL81015_ADD_PKEY.getDescription());
                this.publish(vi);
                ++count;
            }
        }
        return count;
    }

    protected ValidationItem<VirtualFabric> uniqueNameCheck(Item<VirtualFabric> toCheck) {
        long id = toCheck.getId();
        String name = toCheck.getObj().getName();
        for (Item item : this.items) {
            if (item.getId() == id || !((VirtualFabric)item.getObj()).getName().equals(name)) continue;
            return new ValidationItem<VirtualFabric>(STLConstants.K2124_NAME_CHECK.getValue(), UILabels.STL81001_DUP_NAME.getDescription(), UILabels.STL81002_DUP_NAME_SUG.getDescription());
        }
        return null;
    }
}

