/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.virtualfabrics;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.virtualfabrics.ApplicationName;
import com.intel.stl.api.management.virtualfabrics.LimitedMember;
import com.intel.stl.api.management.virtualfabrics.Member;
import com.intel.stl.api.management.virtualfabrics.QOSGroupName;
import com.intel.stl.ui.admin.impl.IRendererModel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.ApplicationRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.BandwidthRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.BaseSLRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.FlowControlDisableRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.HighPriorityRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.HoqLifeRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.LimitedMemberRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.MaxMtuRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.MaxRateRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.MemberRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PKeyRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PktLifeTimeMultRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PreemptRankRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.QosGroupRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.RespSLRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.StandbyRenderer;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class VirtualFabricRendererModel
implements IRendererModel {
    private static final Map<String, Class<? extends IAttrRenderer<?>>> explicitQosMap = new LinkedHashMap<String, Class<? extends IAttrRenderer<?>>>(){
        private static final long serialVersionUID = 7007977245246746722L;
        {
            this.put("PKey", PKeyRenderer.class);
            this.put("MaxMTU", MaxMtuRenderer.class);
            this.put("MaxRate", MaxRateRenderer.class);
            this.put("Standby", StandbyRenderer.class);
            this.put("HighPriority", HighPriorityRenderer.class);
            this.put("Bandwidth", BandwidthRenderer.class);
            this.put("PktLifeTimeMult", PktLifeTimeMultRenderer.class);
            this.put("BaseSL", BaseSLRenderer.class);
            this.put("RespSL", RespSLRenderer.class);
            this.put("FlowControlDisable", FlowControlDisableRenderer.class);
            this.put("PreemptRank", PreemptRankRenderer.class);
            this.put("HoqLife", HoqLifeRenderer.class);
            this.put("Member", MemberRenderer.class);
            this.put("LimitedMember", LimitedMemberRenderer.class);
            this.put("Application", ApplicationRenderer.class);
        }
    };
    private static final Map<String, Class<? extends IAttrRenderer<?>>> qosGroupMap = new LinkedHashMap<String, Class<? extends IAttrRenderer<?>>>(){
        private static final long serialVersionUID = -2297226014988702847L;
        {
            this.put("PKey", PKeyRenderer.class);
            this.put("MaxMTU", MaxMtuRenderer.class);
            this.put("MaxRate", MaxRateRenderer.class);
            this.put("Standby", StandbyRenderer.class);
            this.put("Member", MemberRenderer.class);
            this.put("LimitedMember", LimitedMemberRenderer.class);
            this.put("Application", ApplicationRenderer.class);
            this.put("QOSGroup", QosGroupRenderer.class);
        }
    };
    private Map<String, Class<? extends IAttrRenderer<?>>> map = new HashMap();
    private String[] appNames;
    private String[] dgNames;
    private String[] qosNames;
    private ItemListener qosgItemListener;

    public void setQosNames(String[] qosNames) {
        this.qosNames = qosNames;
    }

    public void setAppNames(String[] appNames) {
        this.appNames = appNames;
    }

    public void setDgNames(String[] dgNames) {
        this.dgNames = dgNames;
    }

    public void setQosGroupMap(boolean isQOSGroup) {
        this.map = isQOSGroup ? qosGroupMap : explicitQosMap;
    }

    public void setQosGroupItemListener(ItemListener listener) {
        this.qosgItemListener = listener;
    }

    @Override
    public String[] getRendererNames() {
        return this.map.keySet().toArray(new String[0]);
    }

    @Override
    public IAttrRenderer<?> getRenderer(String name) throws Exception {
        Class<IAttrRenderer<?>> klass = this.map.get(name);
        if (klass != null) {
            IAttrRenderer<?> res = klass.newInstance();
            this.initRenderer(name, res);
            return res;
        }
        throw new IllegalArgumentException("Unknown renderer '" + name + "'");
    }

    protected void initRenderer(String name, IAttrRenderer<?> renderer) {
        if (name.equals("Member")) {
            MemberRenderer memebers = (MemberRenderer)renderer;
            IAttribute[] sns = new Member[this.dgNames.length];
            for (int i = 0; i < sns.length; ++i) {
                sns[i] = new Member(this.dgNames[i]);
            }
            memebers.setList(sns);
        } else if (name.equals("LimitedMember")) {
            LimitedMemberRenderer limitedMembers = (LimitedMemberRenderer)renderer;
            IAttribute[] sns = new LimitedMember[this.dgNames.length];
            for (int i = 0; i < sns.length; ++i) {
                sns[i] = new LimitedMember(this.dgNames[i]);
            }
            limitedMembers.setList(sns);
        } else if (name.equals("Application")) {
            ApplicationRenderer appMemebers = (ApplicationRenderer)renderer;
            IAttribute[] sns = new ApplicationName[this.appNames.length];
            for (int i = 0; i < sns.length; ++i) {
                sns[i] = new ApplicationName(this.appNames[i]);
            }
            appMemebers.setList(sns);
        } else if (name.equals("QOSGroup")) {
            QosGroupRenderer qosMemebers = (QosGroupRenderer)renderer;
            IAttribute[] sns = new QOSGroupName[this.qosNames.length];
            for (int i = 0; i < sns.length; ++i) {
                sns[i] = new QOSGroupName(this.qosNames[i]);
            }
            qosMemebers.setList(sns);
            if (this.qosgItemListener != null) {
                qosMemebers.setItemListener(this.qosgItemListener);
            }
        }
    }

    public boolean isRepeatabledAttr(String name) {
        return name.equals("Member") || name.equals("LimitedMember") || name.equals("Application");
    }
}

