/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.virtualfabrics;

import com.intel.stl.api.management.applications.Application;
import com.intel.stl.api.management.applications.ApplicationException;
import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.api.management.devicegroups.DeviceGroupException;
import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.api.management.qosgroups.QOSGroupException;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.AbstractEditorController;
import com.intel.stl.ui.admin.view.virtualfabrics.VirtualFabricsEditorPanel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VirtualFabricsEditorController
extends AbstractEditorController<VirtualFabric, VirtualFabricsEditorPanel> {
    public VirtualFabricsEditorController(VirtualFabricsEditorPanel view) {
        super(view);
    }

    @Override
    public void initData() throws Exception {
        List<String> applications = this.getApplicationNames();
        ((VirtualFabricsEditorPanel)this.view).setApplicationNames(applications);
        List<String> devicegroups = this.getDeviceGroupNames();
        ((VirtualFabricsEditorPanel)this.view).setDeviceGroupNames(devicegroups);
        if (this.mgtApi.supportQOSGroup()) {
            Map<String, Boolean> qosMap = this.createQosEnableMap();
            ((VirtualFabricsEditorPanel)this.view).setQosEnableMap(qosMap);
        }
    }

    protected List<String> getApplicationNames() throws ApplicationException {
        List<Application> apps = this.mgtApi.getApplications();
        ArrayList<String> names = new ArrayList<String>(apps.size());
        for (Application app : apps) {
            names.add(app.getName());
        }
        return names;
    }

    protected List<String> getDeviceGroupNames() throws DeviceGroupException {
        List<DeviceGroup> groups = this.mgtApi.getDeviceGroups();
        ArrayList<String> names = new ArrayList<String>(groups.size());
        for (DeviceGroup group : groups) {
            names.add(group.getName());
        }
        return names;
    }

    protected List<String> getQosGroupNames() throws QOSGroupException {
        List<QOSGroup> groups = this.mgtApi.getQOSGroups();
        ArrayList<String> names = new ArrayList<String>(groups.size());
        for (QOSGroup group : groups) {
            names.add(group.getName());
        }
        return names;
    }

    public final Map<String, Boolean> createQosEnableMap() throws QOSGroupException {
        List<QOSGroup> groups = this.mgtApi.getQOSGroups();
        LinkedHashMap<String, Boolean> qosMap = new LinkedHashMap<String, Boolean>();
        for (QOSGroup group : groups) {
            qosMap.put(group.getName(), group.getEnable().isSelected());
        }
        return qosMap;
    }

    @Override
    public void setItem(Item<VirtualFabric> item, Item<VirtualFabric>[] items) {
        super.setItem(item, items);
    }
}

