/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.ui.admin.IItemListListener;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class ItemListPanel<T>
extends JPanel {
    private static final long serialVersionUID = -8018647522341749109L;
    private final String name;
    private JLabel titleLabel;
    private JXList itemList;
    private JPanel ctrPanel;
    private JButton addBtn;
    private JButton removeBtn;
    private final List<IItemListListener> listeners = new CopyOnWriteArrayList<IItemListListener>();

    public ItemListPanel(String name) {
        this.name = name;
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_TABLE_BORDER_GRAY, 1, true), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.titleLabel = ComponentFactory.getH3Label(this.name, 1);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_ORANGE), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        panel.add((Component)this.titleLabel, "North");
        this.itemList = new JXList();
        this.itemList.setSelectionMode(0);
        this.itemList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Item item = (Item)value;
                JLabel label = ComponentFactory.getH5Label(item.getName(), 0);
                label.setOpaque(true);
                label.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
                if (isSelected) {
                    label.setBackground(UIConstants.INTEL_BLUE);
                    label.setForeground(UIConstants.INTEL_WHITE);
                } else {
                    label.setBackground(UIConstants.INTEL_WHITE);
                }
                if (!item.isEditable()) {
                    label.setIcon(UIImages.UNEDITABLE.getImageIcon());
                }
                return label;
            }
        });
        this.itemList.setRolloverEnabled(true);
        ColorHighlighter rooloverHighlighter = new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, UIConstants.INTEL_LIGHT_BLUE, UIConstants.INTEL_WHITE);
        ColorHighlighter evenHighlighter = new ColorHighlighter(HighlightPredicate.EVEN, UIConstants.INTEL_TABLE_ROW_GRAY, null);
        this.itemList.setHighlighters(new Highlighter[]{evenHighlighter, rooloverHighlighter});
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Item item = (Item)ItemListPanel.this.itemList.getSelectedValue();
                ItemListPanel.this.removeBtn.setEnabled(item != null && item.isEditable());
                ItemListPanel.this.fireItemSelected(item);
            }
        });
        JScrollPane pane = new JScrollPane((Component)this.itemList);
        panel.add((Component)pane, "Center");
        this.add((Component)panel, "Center");
        this.ctrPanel = new JPanel();
        this.ctrPanel.setOpaque(false);
        this.installButtons(this.ctrPanel);
        this.add((Component)this.ctrPanel, "South");
    }

    public void setItemRenderer(ListCellRenderer<Item<T>> renderer) {
        this.itemList.setCellRenderer(renderer);
    }

    protected void installButtons(JPanel panel) {
        this.addBtn = ComponentFactory.getIntelActionButton("+");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemListPanel.this.fireAddItem();
            }
        });
        panel.add(this.addBtn);
        this.removeBtn = ComponentFactory.getIntelActionButton("-");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemListPanel.this.fireRemoveItem(ItemListPanel.this.itemList.getSelectedValue());
            }
        });
        panel.add(this.removeBtn);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addBtn.setEnabled(enabled);
        if (!enabled) {
            this.removeBtn.setEnabled(false);
        }
    }

    public void setListModel(ListModel<Item<T>> model) {
        this.itemList.setModel(model);
        boolean hasEditable = false;
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Item<T> item = model.getElementAt(i);
            if (!item.isEditable()) continue;
            hasEditable = true;
            break;
        }
        this.removeBtn.setEnabled(hasEditable);
    }

    protected void fireItemSelected(Object selectedValue) {
        long id = selectedValue == null ? -1L : ((Item)selectedValue).getId();
        for (IItemListListener listener : this.listeners) {
            listener.onSelect(id);
        }
    }

    protected void fireAddItem() {
        for (IItemListListener listener : this.listeners) {
            listener.onAdd();
        }
    }

    protected void fireRemoveItem(Object selectedValue) {
        if (selectedValue == null) {
            return;
        }
        long id = ((Item)selectedValue).getId();
        for (IItemListListener listener : this.listeners) {
            listener.onRemove(id);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.itemList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.itemList.removeListSelectionListener(listener);
    }

    public void selectItem(final int index) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ItemListPanel.this.itemList.setSelectedIndex(index);
                Item item = (Item)ItemListPanel.this.itemList.getSelectedValue();
                ItemListPanel.this.removeBtn.setEnabled(item != null && item.isEditable());
                ItemListPanel.this.revalidate();
                ItemListPanel.this.repaint();
            }
        });
    }

    public void addItemListListener(IItemListListener listener) {
        this.listeners.add(listener);
    }

    public void removeItemListListener(IItemListListener listener) {
        this.listeners.remove(listener);
    }
}

