/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.applications;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.applications.AppSelect;
import com.intel.stl.api.management.applications.Application;
import com.intel.stl.api.management.applications.IncludeApplication;
import com.intel.stl.api.management.applications.MGID;
import com.intel.stl.api.management.applications.ServiceID;
import com.intel.stl.ui.admin.impl.applications.AppRendererModel;
import com.intel.stl.ui.admin.view.AbstractEditorPanel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.applications.AppAttrPanel;
import com.intel.stl.ui.admin.view.applications.IncludeApplicationRenderer;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.VerticalLayout;

public class AppsEditorPanel
extends AbstractEditorPanel<Application> {
    private static final long serialVersionUID = -7830529617793812677L;
    private JScrollPane mainPane;
    private JPanel attrsPanel;
    private final List<AppAttrPanel> appAttrPanels = new ArrayList<AppAttrPanel>();
    private final AppRendererModel rendererModel;

    public AppsEditorPanel(AppRendererModel rendererModel) {
        this.rendererModel = rendererModel;
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPane == null) {
            this.attrsPanel = new JPanel((LayoutManager)new VerticalLayout(10));
            this.attrsPanel.setBackground(UIConstants.INTEL_WHITE);
            this.mainPane = new JScrollPane(this.attrsPanel);
            this.mainPane.setBackground(UIConstants.INTEL_WHITE);
            this.mainPane.setBorder(BorderFactory.createTitledBorder(STLConstants.K2112_ATTRIBUTES.getValue()));
        }
        return this.mainPane;
    }

    @Override
    public void clear() {
        super.clear();
        this.attrsPanel.removeAll();
        this.appAttrPanels.clear();
        this.rendererModel.setAppNames(new String[0]);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void showItemObject(Application app, String[] appNames, boolean isEditable) {
        List<IncludeApplication> list;
        List<AppSelect> list2;
        List<MGID> mgids;
        this.rendererModel.setAppNames(appNames);
        this.attrsPanel.removeAll();
        this.appAttrPanels.clear();
        List<ServiceID> serviceIDs = app.getServiceIDs();
        if (serviceIDs != null) {
            for (ServiceID serviceID : serviceIDs) {
                this.addAttr(serviceID.getType(), serviceID, isEditable);
            }
        }
        if ((mgids = app.getMgids()) != null) {
            for (MGID mGID : mgids) {
                this.addAttr(mGID.getType(), mGID, isEditable);
            }
        }
        if ((list2 = app.getSelects()) != null) {
            for (AppSelect appSelect : list2) {
                this.addAttr(appSelect.getType(), appSelect, isEditable);
            }
        }
        if ((list = app.getIncludeApplications()) != null) {
            for (IncludeApplication incApp : list) {
                this.addAttr(incApp.getType(), incApp, isEditable);
            }
        }
        if (isEditable) {
            AppAttrPanel appAttrPanel = new AppAttrPanel(this, this.rendererModel);
            this.attrsPanel.add(appAttrPanel);
        }
        this.revalidate();
        this.repaint();
    }

    private <E extends IAttribute> void addAttr(String type, E attr, boolean isEditable) {
        AppAttrPanel attrPanel = new AppAttrPanel(this, this.rendererModel);
        attrPanel.setAttr(type, attr, isEditable);
        this.attrsPanel.add(attrPanel);
        this.appAttrPanels.add(attrPanel);
    }

    @Override
    public void itemNameChanged(String oldName, String newName) {
        String[] appNames = this.rendererModel.updateAppName(oldName, newName);
        for (AppAttrPanel aap : this.appAttrPanels) {
            IAttrRenderer<? extends IAttribute> renderer = aap.getAttrRenderer();
            if (!(renderer instanceof IncludeApplicationRenderer)) continue;
            IncludeApplicationRenderer iar = (IncludeApplicationRenderer)renderer;
            IncludeApplication sel = (IncludeApplication)iar.getAttr();
            iar.setList(IncludeApplication.toArry(appNames));
            if (((String)sel.getObject()).equals(oldName)) {
                sel.setValue(newName);
            }
            iar.setAttr(sel);
        }
    }

    @Override
    protected void updateItemObject(Application obj) {
        obj.setName(this.getCurrentName());
        obj.clear();
        for (AppAttrPanel attrPanel : this.appAttrPanels) {
            IAttribute attr;
            IAttrRenderer<? extends IAttribute> renderer = attrPanel.getAttrRenderer();
            if (renderer == null || (attr = renderer.getAttr()) == null) continue;
            attr.installApplication(obj);
        }
    }

    public void beginEdit(AppAttrPanel attrPanel) {
        this.appAttrPanels.add(attrPanel);
        AppAttrPanel aap = new AppAttrPanel(this, this.rendererModel);
        this.attrsPanel.add(aap);
    }

    public void removeEditor(AppAttrPanel appAttrPanel) {
        this.attrsPanel.remove(appAttrPanel);
        this.appAttrPanels.remove(appAttrPanel);
        this.revalidate();
    }

    @Override
    public boolean isEditValid() {
        if (!super.isEditValid()) {
            return false;
        }
        for (AppAttrPanel attrPanel : this.appAttrPanels) {
            IAttrRenderer<? extends IAttribute> renderer = attrPanel.getAttrRenderer();
            if (renderer == null || renderer.isEditValid()) continue;
            return false;
        }
        return true;
    }
}

