/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.devicegroups;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.NumberNode;
import com.intel.stl.api.management.devicegroups.DGSelect;
import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.api.management.devicegroups.IncludeGroup;
import com.intel.stl.api.management.devicegroups.NodeDesc;
import com.intel.stl.api.management.devicegroups.NodeTypeAttr;
import com.intel.stl.ui.admin.impl.devicegroups.DeviceGroupRendererModel;
import com.intel.stl.ui.admin.impl.devicegroups.IAttributeListener;
import com.intel.stl.ui.admin.view.AbstractEditorPanel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.devicegroups.DevicegroupAttrPanel;
import com.intel.stl.ui.admin.view.devicegroups.DevicegroupSelectionPanel;
import com.intel.stl.ui.admin.view.devicegroups.IncludeGroupRenderer;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.WidgetName;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.jdesktop.swingx.VerticalLayout;

public class DevicegroupsEditorPanel
extends AbstractEditorPanel<DeviceGroup> {
    private static final long serialVersionUID = -4137802341150098071L;
    private JSplitPane mainComp;
    private DevicegroupSelectionPanel selectionPanel;
    private JToolBar dividerToolBar;
    private JButton addBtn;
    private JScrollPane scrollPane;
    private JPanel attrsPanel;
    private final List<DevicegroupAttrPanel> dgAttrPanels = new ArrayList<DevicegroupAttrPanel>();
    private IAttributeListener attrListener;
    private final DeviceGroupRendererModel rendererModel;

    public DevicegroupsEditorPanel(DeviceGroupRendererModel rendererModel) {
        this.rendererModel = rendererModel;
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainComp == null) {
            this.mainComp = new JSplitPane();
            final JToolBar toolbar = this.getDividerToolBar();
            this.mainComp.setUI(new BasicSplitPaneUI(){

                @Override
                public BasicSplitPaneDivider createDefaultDivider() {
                    BasicSplitPaneDivider divider = new BasicSplitPaneDivider(this){
                        private static final long serialVersionUID = -4518403689269742327L;

                        @Override
                        public int getDividerSize() {
                            if (this.getOrientation() == 1) {
                                return toolbar.getPreferredSize().width + 5;
                            }
                            return toolbar.getPreferredSize().height + 5;
                        }
                    };
                    divider.setLayout(new GridBagLayout());
                    divider.add((Component)toolbar, new GridBagConstraints());
                    return divider;
                }
            });
            DevicegroupSelectionPanel left = this.getSelctionPanel();
            this.mainComp.setLeftComponent(left);
            JComponent right = this.getAttributesPanel();
            this.mainComp.setRightComponent(right);
        }
        return this.mainComp;
    }

    protected JToolBar getDividerToolBar() {
        if (this.dividerToolBar == null) {
            this.dividerToolBar = new JToolBar(1);
            this.dividerToolBar.setFloatable(false);
            this.dividerToolBar.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    DevicegroupsEditorPanel.this.dividerToolBar.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            this.addBtn = new JButton(UIImages.MOVE.getImageIcon());
            this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DevicegroupsEditorPanel.this.attrListener != null) {
                        DevicegroupsEditorPanel.this.attrListener.onAdd(DevicegroupsEditorPanel.this.selectionPanel.getSelectorName());
                    }
                }
            });
            this.addBtn.setName(WidgetName.ADMIN_DG_MOVE.name());
            this.dividerToolBar.add(this.addBtn);
        }
        return this.dividerToolBar;
    }

    public DevicegroupSelectionPanel getSelctionPanel() {
        if (this.selectionPanel == null) {
            this.selectionPanel = new DevicegroupSelectionPanel();
        }
        return this.selectionPanel;
    }

    protected JComponent getAttributesPanel() {
        if (this.scrollPane == null) {
            this.attrsPanel = new JPanel((LayoutManager)new VerticalLayout(10));
            this.attrsPanel.setBackground(UIConstants.INTEL_WHITE);
            this.scrollPane = new JScrollPane(this.attrsPanel);
            this.scrollPane.setBackground(UIConstants.INTEL_WHITE);
            this.scrollPane.setBorder(BorderFactory.createTitledBorder(STLConstants.K2112_ATTRIBUTES.getValue()));
        }
        return this.scrollPane;
    }

    public void setAttributeListener(IAttributeListener listener) {
        this.attrListener = listener;
    }

    @Override
    public void clear() {
        super.clear();
        this.attrsPanel.removeAll();
        this.dgAttrPanels.clear();
        this.rendererModel.setDgNames(new String[0]);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void showItemObject(DeviceGroup dg, String[] itemNames, boolean isEditable) {
        List<IncludeGroup> list;
        List<DGSelect> list2;
        List<NodeDesc> list3;
        List<NodeTypeAttr> nodeTypes;
        this.rendererModel.setDgNames(itemNames);
        this.attrsPanel.removeAll();
        this.dgAttrPanels.clear();
        List<NumberNode> ids = dg.getIDs();
        if (ids != null) {
            for (NumberNode numberNode : ids) {
                this.addAttr(numberNode.getType(), numberNode, isEditable);
            }
        }
        if ((nodeTypes = dg.getNodeTypes()) != null) {
            for (NodeTypeAttr nodeTypeAttr : nodeTypes) {
                this.addAttr(nodeTypeAttr.getType(), nodeTypeAttr, isEditable);
            }
        }
        if ((list3 = dg.getNodeDesc()) != null) {
            for (NodeDesc nodeDesc : list3) {
                this.addAttr(nodeDesc.getType(), nodeDesc, isEditable);
            }
        }
        if ((list2 = dg.getSelects()) != null) {
            for (DGSelect sel : list2) {
                this.addAttr(sel.getType(), sel, isEditable);
            }
        }
        if ((list = dg.getIncludeGroups()) != null) {
            for (IncludeGroup incGroup : list) {
                this.addAttr(incGroup.getType(), incGroup, isEditable);
            }
        }
        this.addBtn.setEnabled(isEditable);
        this.revalidate();
        this.repaint();
    }

    private <E extends IAttribute> void addAttr(String type, E attr, boolean isEditable) {
        DevicegroupAttrPanel attrPanel = new DevicegroupAttrPanel(this, this.rendererModel);
        attrPanel.setAttr(type, attr, isEditable);
        this.attrsPanel.add(attrPanel);
        this.dgAttrPanels.add(attrPanel);
    }

    @Override
    public void itemNameChanged(String oldName, String newName) {
        String[] dgNames = this.rendererModel.updateDGName(oldName, newName);
        for (DevicegroupAttrPanel dap : this.dgAttrPanels) {
            IAttrRenderer<? extends IAttribute> renderer = dap.getAttrRenderer();
            if (!(renderer instanceof IncludeGroupRenderer)) continue;
            IncludeGroupRenderer iar = (IncludeGroupRenderer)renderer;
            IncludeGroup sel = (IncludeGroup)iar.getAttr();
            iar.setList(IncludeGroup.toArry(dgNames));
            if (((String)sel.getObject()).equals(oldName)) {
                sel.setValue(newName);
            }
            iar.setAttr(sel);
        }
    }

    @Override
    protected void updateItemObject(DeviceGroup obj) {
        obj.setName(this.getCurrentName());
        obj.clear();
        for (DevicegroupAttrPanel attrPanel : this.dgAttrPanels) {
            IAttribute attr;
            IAttrRenderer<? extends IAttribute> renderer = attrPanel.getAttrRenderer();
            if (renderer == null || (attr = renderer.getAttr()) == null) continue;
            attr.installDevieGroup(obj);
        }
    }

    public void removeEditor(DevicegroupAttrPanel appAttrPanel) {
        IAttrRenderer<? extends IAttribute> renderer;
        this.attrsPanel.remove(appAttrPanel);
        this.dgAttrPanels.remove(appAttrPanel);
        this.revalidate();
        this.repaint();
        if (this.attrListener != null && appAttrPanel != null && (renderer = appAttrPanel.getAttrRenderer()) != null) {
            this.attrListener.onRemove(renderer.getAttr());
        }
    }

    public void addAttr(IAttribute attr) {
        this.addAttr(attr.getType(), attr, true);
        this.revalidate();
        this.repaint();
    }
}

