/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.logs;

import com.intel.stl.ui.admin.impl.logs.ITextMenuListener;
import com.intel.stl.ui.admin.impl.logs.TextEvent;
import com.intel.stl.ui.admin.impl.logs.TextEventType;
import com.intel.stl.ui.common.view.TextMenuItem;
import com.intel.stl.ui.common.view.TextPopupUtil;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class TextMenuPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 3208426280088071528L;
    private final JPopupMenu menuText;
    private ITextMenuListener textListener;
    private String selectedText;
    private String clipboardContents;

    public TextMenuPanel(List<TextEventType> eventTypes) {
        this.menuText = this.createPopupMenu(eventTypes);
    }

    public void setTextMenuListener(ITextMenuListener listener) {
        this.textListener = listener;
    }

    protected JPopupMenu createPopupMenu(List<TextEventType> eventTypes) {
        return TextPopupUtil.createPopupMenu(eventTypes, new TextPopupUtil.ITextMenuAction(){

            @Override
            public Action createTextMenuAction(final byte eventId) {
                AbstractAction action = null;
                switch (TextEventType.getType(eventId)) {
                    case COPY: {
                        action = new DefaultEditorKit.CopyAction();
                        break;
                    }
                    case PASTE: {
                        action = new DefaultEditorKit.PasteAction();
                        break;
                    }
                    case HIGHLIGHT: {
                        action = new AbstractAction(){
                            private static final long serialVersionUID = 3808622111777476707L;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TextMenuPanel.this.fireTextEvent(new TextEvent(TextEventType.getType(eventId), TextMenuPanel.this.selectedText));
                            }
                        };
                    }
                }
                return action;
            }
        });
    }

    protected void fireTextEvent(TextEvent event) {
        this.textListener.doAction(event);
    }

    protected void show(MouseEvent e) {
        this.menuText.show(e.getComponent(), e.getX(), e.getY());
    }

    public void setMenuEnable(TextEventType type, boolean b) {
        boolean found = false;
        Component[] components = this.menuText.getComponents();
        for (int i = 0; !found && i < components.length; ++i) {
            if (!(components[i] instanceof TextMenuItem) || !((TextMenuItem)components[i]).getTextEventType().equals((Object)type)) continue;
            ((TextMenuItem)components[i]).setEnabled(b);
            found = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.show(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTextComponent component = (JTextComponent)e.getSource();
        if (e.getClickCount() > 1) {
            if (component instanceof JTextField) {
                JTextField txtfld = (JTextField)component;
                int endPosition = txtfld.getText().length();
                txtfld.select(endPosition, endPosition);
            }
        } else {
            if (component instanceof JTextField) {
                ((JTextField)component).selectAll();
            } else if (component instanceof JTextArea) {
                // empty if block
            }
            try {
                this.clipboardContents = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                this.setMenuEnable(TextEventType.PASTE, !this.clipboardContents.isEmpty());
            }
            catch (HeadlessException | UnsupportedFlavorException | IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int endPosition;
        JTextComponent component = (JTextComponent)e.getSource();
        this.selectedText = component.getSelectedText();
        int startPosition = component.getSelectionStart();
        boolean menuEnabled = startPosition != (endPosition = component.getSelectionEnd());
        this.setMenuEnable(TextEventType.COPY, menuEnabled);
        this.setMenuEnable(TextEventType.HIGHLIGHT, menuEnabled);
        try {
            this.clipboardContents = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            this.setMenuEnable(TextEventType.PASTE, !this.clipboardContents.isEmpty());
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException e1) {
            e1.printStackTrace();
        }
        if (e.isPopupTrigger()) {
            this.show(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

