/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.qosgroups;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.api.management.virtualfabrics.Enable;
import com.intel.stl.ui.admin.impl.qosgroups.QosGroupRendererModel;
import com.intel.stl.ui.admin.view.AbstractEditorPanel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.qosgroups.QosAttrPanel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.VerticalLayout;

public class QOSGsEditorPanel
extends AbstractEditorPanel<QOSGroup> {
    private static final long serialVersionUID = 6842524404375810929L;
    private JPanel mainPanel;
    private JPanel attrsPanel;
    private JCheckBox enableBox;
    private JPanel basicPanel;
    private final List<QosAttrPanel> qosAttrPanels = new ArrayList<QosAttrPanel>();
    private final QosGroupRendererModel rendererModel;
    private QosAttrPanel addAttrPanel;

    public QOSGsEditorPanel(QosGroupRendererModel rendererModel) {
        this.rendererModel = rendererModel;
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.setBackground(UIConstants.INTEL_WHITE);
            this.mainPanel.setBorder(BorderFactory.createTitledBorder(STLConstants.K2112_ATTRIBUTES.getValue()));
            JPanel panel = this.getBasicPanel();
            this.mainPanel.add((Component)panel, "North");
            this.attrsPanel = new JPanel((LayoutManager)new VerticalLayout(10));
            this.attrsPanel.setOpaque(false);
            JScrollPane scrollPane = new JScrollPane(this.attrsPanel);
            this.mainPanel.add((Component)scrollPane, "Center");
        }
        return this.mainPanel;
    }

    protected JPanel getBasicPanel() {
        if (this.basicPanel == null) {
            this.basicPanel = new JPanel(new FlowLayout(3, 10, 5));
            this.basicPanel.setOpaque(false);
            this.enableBox = ComponentFactory.getIntelCheckBox(STLConstants.K0445_ENABLE.getValue());
            this.basicPanel.add(this.enableBox);
        }
        return this.basicPanel;
    }

    public void setEnabledActionListener(ActionListener listener) {
        this.enableBox.addActionListener(listener);
    }

    @Override
    public void clear() {
        super.clear();
        this.attrsPanel.removeAll();
        this.qosAttrPanels.clear();
        this.enableBox.setSelected(false);
        this.enableBox.setEnabled(false);
        this.rendererModel.setQosNames(new String[0]);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void showItemObject(QOSGroup qos, String[] qosNames, boolean isEditable) {
        this.attrsPanel.removeAll();
        this.qosAttrPanels.clear();
        this.setBasicAttrs(qos, isEditable);
        List<IAttribute> attrs = this.getAdvancedAttrs(qos);
        String[] attrNAmes = this.addAttrs(attrs, isEditable);
        if (isEditable) {
            this.addAttrPanel = new QosAttrPanel(this, this.rendererModel);
            this.addAttrPanel.setDisabledAttrs(attrNAmes);
            this.attrsPanel.add(this.addAttrPanel);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void itemNameChanged(String oldName, String newName) {
    }

    protected void setBasicAttrs(QOSGroup qos, boolean isEditable) {
        this.enableBox.setSelected(qos.getEnable().isSelected());
        this.enableBox.setEnabled(isEditable);
    }

    protected List<IAttribute> getAdvancedAttrs(QOSGroup qos) {
        ArrayList<IAttribute> attrs = new ArrayList<IAttribute>();
        if (qos.getHighPriority() != null) {
            attrs.add(qos.getHighPriority());
        }
        if (qos.getBandwidth() != null) {
            attrs.add(qos.getBandwidth());
        }
        if (qos.getPktLifeTimeMult() != null) {
            attrs.add(qos.getPktLifeTimeMult());
        }
        if (qos.getBaseSL() != null) {
            attrs.add(qos.getBaseSL());
        }
        if (qos.getRespSL() != null) {
            attrs.add(qos.getRespSL());
        }
        if (qos.getFlowControlDisable() != null) {
            attrs.add(qos.getFlowControlDisable());
        }
        if (qos.getPreemptRank() != null) {
            attrs.add(qos.getPreemptRank());
        }
        if (qos.getHoqLife() != null) {
            attrs.add(qos.getHoqLife());
        }
        if (qos.getMulticaseSL() != null) {
            attrs.add(qos.getMulticaseSL());
        }
        return attrs;
    }

    protected String[] addAttrs(List<IAttribute> attrs, boolean isEditable) {
        HashSet<String> attrNameSet = new HashSet<String>();
        for (IAttribute attr : attrs) {
            QosAttrPanel attrPanel = new QosAttrPanel(this, this.rendererModel);
            attrPanel.setAttr(attr.getType(), attr, isEditable);
            this.attrsPanel.add(attrPanel);
            this.qosAttrPanels.add(attrPanel);
            String rendererName = attrPanel.getRendererName();
            attrNameSet.add(rendererName);
        }
        String[] attrNames = attrNameSet.toArray(new String[0]);
        for (QosAttrPanel vfap : this.qosAttrPanels) {
            vfap.setDisabledAttrs(attrNames);
        }
        return attrNames;
    }

    @Override
    protected void updateItemObject(QOSGroup obj) {
        obj.setName(this.getCurrentName());
        obj.setEnable(new Enable(this.enableBox.isSelected()));
        obj.clear();
        for (QosAttrPanel attrPanel : this.qosAttrPanels) {
            IAttribute attr;
            IAttrRenderer<? extends IAttribute> renderer = attrPanel.getAttrRenderer();
            if (renderer == null || (attr = renderer.getAttr()) == null) continue;
            attr.installQOSGroup(obj);
        }
    }

    public void beginEdit(QosAttrPanel attrPanel) {
        String name = attrPanel.getRendererName();
        HashSet<String> attrNameSet = new HashSet<String>();
        for (QosAttrPanel vfap : this.qosAttrPanels) {
            vfap.addDisabledAttr(name);
            attrNameSet.add(vfap.getRendererName());
        }
        this.qosAttrPanels.add(attrPanel);
        attrNameSet.add(name);
        attrPanel.setDisabledAttrs(attrNameSet.toArray(new String[0]));
        this.addAttrPanel = new QosAttrPanel(this, this.rendererModel);
        this.addAttrPanel.setDisabledAttrs(attrNameSet.toArray(new String[0]));
        this.attrsPanel.add(this.addAttrPanel);
    }

    public void removeEditor(QosAttrPanel qosAttrPanel) {
        this.attrsPanel.remove(qosAttrPanel);
        this.qosAttrPanels.remove(qosAttrPanel);
        this.revalidate();
    }

    @Override
    public boolean isEditValid() {
        if (!super.isEditValid()) {
            return false;
        }
        for (QosAttrPanel attrPanel : this.qosAttrPanels) {
            IAttrRenderer<? extends IAttribute> renderer = attrPanel.getAttrRenderer();
            if (renderer == null || renderer.isEditValid()) continue;
            return false;
        }
        return true;
    }

    public void changeEditorRenderer(String oldRenderer, String newRenderer) {
        for (QosAttrPanel qgap : this.qosAttrPanels) {
            qgap.addDisabledAttr(newRenderer);
            qgap.removeDisabledAttr(oldRenderer);
        }
        if (this.addAttrPanel != null) {
            this.addAttrPanel.addDisabledAttr(newRenderer);
            this.addAttrPanel.removeDisabledAttr(oldRenderer);
        }
    }
}

