/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.virtualfabrics;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.virtualfabrics.Enable;
import com.intel.stl.api.management.virtualfabrics.QOSGroupName;
import com.intel.stl.api.management.virtualfabrics.Qos;
import com.intel.stl.api.management.virtualfabrics.Security;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.ui.admin.impl.virtualfabrics.VirtualFabricRendererModel;
import com.intel.stl.ui.admin.view.AbstractEditorPanel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.VirtualFabricAttrPanel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.VerticalLayout;

public class VirtualFabricsEditorPanel
extends AbstractEditorPanel<VirtualFabric> {
    private static final long serialVersionUID = -6284544057548609879L;
    private JPanel mainPanel;
    private JPanel basicPanel;
    private JCheckBox enableBox;
    private JCheckBox securityBox;
    private JCheckBox qosBox;
    private JPanel attrsPanel;
    private final List<VirtualFabricAttrPanel> attrPanels = new ArrayList<VirtualFabricAttrPanel>();
    private Map<String, Boolean> qosMap = new HashMap<String, Boolean>();
    private VirtualFabricAttrPanel addAttrPanel;
    private final VirtualFabricRendererModel rendererModel;

    public VirtualFabricsEditorPanel(VirtualFabricRendererModel rendererModel) {
        this.rendererModel = rendererModel;
        rendererModel.setQosGroupItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    QOSGroupName qos = (QOSGroupName)e.getItem();
                    Boolean enabled = (Boolean)VirtualFabricsEditorPanel.this.qosMap.get(qos.getValue());
                    if (enabled != null) {
                        VirtualFabricsEditorPanel.this.qosBox.setSelected(enabled);
                    }
                }
            }
        });
    }

    public void setQosEnableMap(Map<String, Boolean> qosMap) {
        this.qosMap = qosMap;
        this.rendererModel.setQosNames(qosMap.keySet().toArray(new String[0]));
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.setBackground(UIConstants.INTEL_WHITE);
            this.mainPanel.setBorder(BorderFactory.createTitledBorder(STLConstants.K2112_ATTRIBUTES.getValue()));
            JPanel panel = this.getBasicPanel();
            this.mainPanel.add((Component)panel, "North");
            this.attrsPanel = new JPanel((LayoutManager)new VerticalLayout(10));
            this.attrsPanel.setOpaque(false);
            JScrollPane scrollPane = new JScrollPane(this.attrsPanel);
            this.mainPanel.add((Component)scrollPane, "Center");
        }
        return this.mainPanel;
    }

    protected JPanel getBasicPanel() {
        if (this.basicPanel == null) {
            this.basicPanel = new JPanel(new FlowLayout(3, 10, 5));
            this.basicPanel.setOpaque(false);
            this.enableBox = ComponentFactory.getIntelCheckBox(STLConstants.K0445_ENABLE.getValue());
            this.basicPanel.add(this.enableBox);
            this.securityBox = ComponentFactory.getIntelCheckBox(STLConstants.K0072_SECURITY.getValue());
            this.basicPanel.add(this.securityBox);
            this.qosBox = ComponentFactory.getIntelCheckBox(STLConstants.K2141_QOS.getValue());
            this.basicPanel.add(this.qosBox);
        }
        return this.basicPanel;
    }

    public void setEnabledActionListener(ActionListener listener) {
        this.enableBox.addActionListener(listener);
    }

    @Override
    public void clear() {
        super.clear();
        this.attrsPanel.removeAll();
        this.attrPanels.clear();
        this.enableBox.setSelected(false);
        this.enableBox.setEnabled(false);
        this.securityBox.setSelected(false);
        this.securityBox.setEnabled(false);
        this.qosBox.setSelected(false);
        this.qosBox.setEnabled(false);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void showItemObject(VirtualFabric vf, String[] itemNames, boolean isEditable) {
        this.attrsPanel.removeAll();
        this.attrPanels.clear();
        this.checkQOS(vf);
        this.checkPKey(vf);
        if (vf.getQosGroup() != null) {
            this.rendererModel.setQosGroupMap(true);
            this.qosBox.setEnabled(false);
        } else {
            this.rendererModel.setQosGroupMap(false);
            this.qosBox.setEnabled(true);
        }
        this.setBasicAttrs(vf, isEditable);
        List<IAttribute> attrs = this.getAdvancedAttrs(vf);
        String[] attrNAmes = this.addAttrs(attrs, isEditable);
        if (isEditable) {
            this.addAttrPanel = new VirtualFabricAttrPanel(this, this.rendererModel);
            this.addAttrPanel.setDisabledAttrs(attrNAmes);
            this.attrsPanel.add(this.addAttrPanel);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void itemNameChanged(String oldName, String newName) {
    }

    protected void setBasicAttrs(VirtualFabric vf, boolean isEditable) {
        this.enableBox.setSelected(vf.getEnable().isSelected());
        this.enableBox.setEnabled(isEditable);
        this.securityBox.setSelected(vf.getSecurity().isSelected());
        this.securityBox.setEnabled(isEditable);
        this.setQOSCheckBox(vf);
        if (!isEditable) {
            this.qosBox.setEnabled(false);
        }
    }

    protected List<IAttribute> getAdvancedAttrs(VirtualFabric vf) {
        ArrayList<IAttribute> attrs = new ArrayList<IAttribute>();
        if (vf.getPKey() != null) {
            attrs.add(vf.getPKey());
        }
        if (vf.getMaxMtu() != null) {
            attrs.add(vf.getMaxMtu());
        }
        if (vf.getMaxRate() != null) {
            attrs.add(vf.getMaxRate());
        }
        if (vf.getStandby() != null) {
            attrs.add(vf.getStandby());
        }
        if (vf.getHighPriority() != null) {
            attrs.add(vf.getHighPriority());
        }
        if (vf.getBandwidth() != null) {
            attrs.add(vf.getBandwidth());
        }
        if (vf.getPktLifeTimeMult() != null) {
            attrs.add(vf.getPktLifeTimeMult());
        }
        if (vf.getBaseSL() != null) {
            attrs.add(vf.getBaseSL());
        }
        if (vf.getRespSL() != null) {
            attrs.add(vf.getRespSL());
        }
        if (vf.getFlowControlDisable() != null) {
            attrs.add(vf.getFlowControlDisable());
        }
        if (vf.getPreemptRank() != null) {
            attrs.add(vf.getPreemptRank());
        }
        if (vf.getHoqLife() != null) {
            attrs.add(vf.getHoqLife());
        }
        if (vf.getMembers() != null) {
            attrs.addAll(vf.getMembers());
        }
        if (vf.getApplications() != null) {
            attrs.addAll(vf.getApplications());
        }
        if (vf.getQosGroup() != null) {
            attrs.add(vf.getQosGroup());
        }
        return attrs;
    }

    protected String[] addAttrs(List<IAttribute> attrs, boolean isEditable) {
        HashSet<String> attrNameSet = new HashSet<String>();
        for (IAttribute attr : attrs) {
            VirtualFabricAttrPanel attrPanel = new VirtualFabricAttrPanel(this, this.rendererModel);
            attrPanel.setAttr(attr.getType(), attr, isEditable);
            this.attrsPanel.add(attrPanel);
            this.attrPanels.add(attrPanel);
            String rendererName = attrPanel.getRendererName();
            if (this.rendererModel.isRepeatabledAttr(rendererName)) continue;
            attrNameSet.add(rendererName);
        }
        String[] attrNames = attrNameSet.toArray(new String[0]);
        for (VirtualFabricAttrPanel vfap : this.attrPanels) {
            vfap.setDisabledAttrs(attrNames);
        }
        return attrNames;
    }

    @Override
    protected void updateItemObject(VirtualFabric obj) {
        obj.setName(this.getCurrentName());
        obj.setEnable(new Enable(this.enableBox.isSelected()));
        obj.setSecurity(new Security(this.securityBox.isSelected()));
        if (obj.getQosGroup() == null) {
            obj.setQos(new Qos(this.qosBox.isSelected()));
        }
        obj.clear();
        for (VirtualFabricAttrPanel attrPanel : this.attrPanels) {
            IAttribute attr;
            IAttrRenderer<? extends IAttribute> renderer = attrPanel.getAttrRenderer();
            if (renderer == null || (attr = renderer.getAttr()) == null) continue;
            attr.installVirtualFabric(obj);
        }
    }

    public void beginEdit(VirtualFabricAttrPanel attrPanel) {
        String name = attrPanel.getRendererName();
        boolean toDisable = !this.rendererModel.isRepeatabledAttr(name);
        HashSet<String> attrNameSet = new HashSet<String>();
        for (VirtualFabricAttrPanel vfap : this.attrPanels) {
            if (toDisable) {
                vfap.addDisabledAttr(name);
            }
            if (this.rendererModel.isRepeatabledAttr(vfap.getRendererName())) continue;
            attrNameSet.add(vfap.getRendererName());
        }
        this.attrPanels.add(attrPanel);
        if (toDisable) {
            attrNameSet.add(name);
        }
        attrPanel.setDisabledAttrs(attrNameSet.toArray(new String[0]));
        this.addAttrPanel = new VirtualFabricAttrPanel(this, this.rendererModel);
        this.addAttrPanel.setDisabledAttrs(attrNameSet.toArray(new String[0]));
        this.attrsPanel.add(this.addAttrPanel);
    }

    public void removeEditor(VirtualFabricAttrPanel attrPanel) {
        this.attrsPanel.remove(attrPanel);
        String name = attrPanel.getRendererName();
        if (!this.rendererModel.isRepeatabledAttr(name)) {
            for (VirtualFabricAttrPanel vfap : this.attrPanels) {
                vfap.removeDisabledAttr(name);
            }
        }
        this.addAttrPanel.removeDisabledAttr(name);
        this.attrPanels.remove(attrPanel);
        this.revalidate();
    }

    public void changeEditorRenderer(String oldRenderer, String newRenderer) {
        boolean disableOld = !this.rendererModel.isRepeatabledAttr(oldRenderer);
        boolean disableNew = !this.rendererModel.isRepeatabledAttr(newRenderer);
        for (VirtualFabricAttrPanel vfap : this.attrPanels) {
            if (disableNew) {
                vfap.addDisabledAttr(newRenderer);
            }
            if (!disableOld) continue;
            vfap.removeDisabledAttr(oldRenderer);
        }
        if (this.addAttrPanel != null) {
            if (disableNew) {
                this.addAttrPanel.addDisabledAttr(newRenderer);
            }
            if (disableOld) {
                this.addAttrPanel.removeDisabledAttr(oldRenderer);
            }
        }
    }

    public void setApplicationNames(List<String> applications) {
        this.rendererModel.setAppNames(applications.toArray(new String[0]));
    }

    public void setDeviceGroupNames(List<String> devicegroups) {
        this.rendererModel.setDgNames(devicegroups.toArray(new String[0]));
    }

    public void setQosGroupNames(List<String> qosgroups) {
        this.rendererModel.setQosNames(qosgroups.toArray(new String[0]));
    }

    public void setQOSCheckBox(VirtualFabric vf) {
        QOSGroupName qosgroup = vf.getQosGroup();
        if (qosgroup != null) {
            Boolean enabled = this.qosMap.get(qosgroup.getValue());
            if (enabled != null) {
                this.qosBox.setSelected(enabled);
            } else {
                this.qosBox.setSelected(false);
            }
        } else {
            Qos qos = vf.getQos();
            if (qos != null) {
                this.qosBox.setSelected(qos.isSelected());
            } else {
                this.qosBox.setSelected(false);
            }
        }
    }

    public void checkQOS(VirtualFabric vf) {
        if (vf.getQosGroup() != null && (vf.getBandwidth() != null || vf.getBaseSL() != null || vf.getRespSL() != null || vf.getFlowControlDisable() != null || vf.getHighPriority() != null || vf.getHoqLife() != null || vf.getPktLifeTimeMult() != null || vf.getPreemptRank() != null)) {
            throw new IllegalArgumentException("Cannot support both explicit and implicit QOSGroup in VF. Please check the value of " + vf);
        }
    }

    public void checkPKey(VirtualFabric vf) {
        if (vf.getQosGroup() != null && vf.getPKey() == null) {
            throw new IllegalArgumentException("PKey is a required field if specified as QOSGroup!");
        }
    }

    @Override
    protected boolean isEditValid() {
        if (!super.isEditValid()) {
            return false;
        }
        for (VirtualFabricAttrPanel attrPanel : this.attrPanels) {
            IAttrRenderer<? extends IAttribute> renderer = attrPanel.getAttrRenderer();
            if (renderer == null || renderer.isEditValid()) continue;
            return false;
        }
        return true;
    }
}

