/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.alert;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.ui.alert.IEventObserver;
import java.util.ArrayList;
import java.util.List;

public abstract class EventProcesser
implements IEventObserver {
    private EventType[] targetTypes;
    private final List<EventDescription> targetEvents = new ArrayList<EventDescription>();

    public void setTargetTypes(EventType ... targetTypes) {
        this.targetTypes = targetTypes;
    }

    @Override
    public void onEvents(EventDescription[] events) {
        this.targetEvents.clear();
        for (EventDescription event : events) {
            if (!this.isTarget(event.getType())) continue;
            this.targetEvents.add(event);
        }
        try {
            if (!this.targetEvents.isEmpty()) {
                this.processEvents(this.targetEvents);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.finishProcess();
    }

    protected boolean isTarget(EventType type) {
        for (EventType targetType : this.targetTypes) {
            if (targetType != type) continue;
            return true;
        }
        return false;
    }

    protected abstract void processEvents(List<EventDescription> var1);

    protected abstract void finishProcess();
}

