/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.alert;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.IEventSource;
import com.intel.stl.api.notice.NodeSource;
import com.intel.stl.ui.alert.EventBusProcessor;
import com.intel.stl.ui.event.NodeUpdateEvent;
import com.intel.stl.ui.framework.IAppEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeEventProcessor
extends EventBusProcessor<NodeUpdateEvent> {
    private static Logger log = LoggerFactory.getLogger(NodeEventProcessor.class);

    public NodeEventProcessor(MBassador<IAppEvent> eventBus) {
        super(eventBus);
    }

    @Override
    protected EventType[] getTargetTypes() {
        return new EventType[]{EventType.SM_TOPO_CHANGE, EventType.PORT_ACTIVE, EventType.PORT_INACTIVE, EventType.SM_CONNECTION_ESTABLISH, EventType.SM_CONNECTION_LOST};
    }

    @Override
    protected Collection<NodeUpdateEvent> createBusEventCollection() {
        return new LinkedHashSet<NodeUpdateEvent>();
    }

    @Override
    protected NodeUpdateEvent toBusEvent(List<EventDescription> evts) {
        LinkedHashSet<Integer> nodesToUpdate = new LinkedHashSet<Integer>();
        for (EventDescription evt : evts) {
            Set<Integer> relatedNodes;
            IEventSource source = evt.getSource();
            if (source instanceof NodeSource) {
                nodesToUpdate.add(((NodeSource)source).getLid());
            } else {
                log.info("Unsupported event source " + source);
            }
            if ((relatedNodes = evt.getRelatedNodes()) == null) continue;
            nodesToUpdate.addAll(relatedNodes);
        }
        int[] lids = new int[nodesToUpdate.size()];
        int i = 0;
        for (Integer lid : nodesToUpdate) {
            lids[i++] = lid;
        }
        return new NodeUpdateEvent(lids, this);
    }
}

