/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.alert;

import com.intel.stl.api.Utils;
import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.ui.alert.INotifyRule;
import com.intel.stl.ui.alert.MailNotifier;
import com.intel.stl.ui.alert.MailNotifyRule;
import com.intel.stl.ui.alert.NoticeNotifier;
import com.intel.stl.ui.alert.NotifierType;
import com.intel.stl.ui.main.Context;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifierFactory {
    private static Logger log = LoggerFactory.getLogger(NotifierFactory.class);

    public static NoticeNotifier createNotifier(NotifierType type, Context context) throws IllegalArgumentException {
        UserSettings settings = context.getUserSettings();
        if (settings == null) {
            throw new RuntimeException("No user settings found");
        }
        if (type == NotifierType.MAIL) {
            log.debug("NotifierFactory: Mail notifier created.");
            ArrayList<EventRule> eventRules = new ArrayList<EventRule>();
            List<EventRule> savedEventRules = settings.getEventRules();
            if (savedEventRules != null) {
                eventRules.addAll(savedEventRules);
            }
            ArrayList<INotifyRule> notifyRules = new ArrayList<INotifyRule>();
            block0: for (EventRule eventRule : eventRules) {
                List<EventRuleAction> actions = eventRule.getEventActions();
                for (EventRuleAction action : actions) {
                    if (!action.equals((Object)EventRuleAction.SEND_EMAIL)) continue;
                    notifyRules.add(new MailNotifyRule(eventRule));
                    continue block0;
                }
            }
            String mailRecepientsStr = settings.getPreferences().get("Preference").getProperty("mailRecipients");
            List<String> mailRecepients = Utils.concatenatedStringToList(mailRecepientsStr, ";");
            return new MailNotifier(context, notifyRules, mailRecepients);
        }
        IllegalArgumentException e = new IllegalArgumentException("Unsupported Notifier Type " + (Object)((Object)type));
        log.error("NoticeNotifier: createNotifier exception: " + e.getMessage());
        throw e;
    }
}

