/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.alert;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.IEventSource;
import com.intel.stl.api.notice.PortSource;
import com.intel.stl.ui.alert.EventBusProcessor;
import com.intel.stl.ui.event.PortUpdateEvent;
import com.intel.stl.ui.framework.IAppEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortEventProcessor
extends EventBusProcessor<PortUpdateEvent> {
    private static Logger log = LoggerFactory.getLogger(PortEventProcessor.class);

    public PortEventProcessor(MBassador<IAppEvent> eventBus) {
        super(eventBus);
    }

    @Override
    protected EventType[] getTargetTypes() {
        return new EventType[]{EventType.PORT_ACTIVE, EventType.PORT_INACTIVE};
    }

    @Override
    protected Collection<PortUpdateEvent> createBusEventCollection() {
        return new LinkedHashSet<PortUpdateEvent>();
    }

    @Override
    protected PortUpdateEvent toBusEvent(List<EventDescription> evts) {
        LinkedHashSet<PortSource> tmp = new LinkedHashSet<PortSource>(evts.size());
        for (EventDescription evt : evts) {
            IEventSource source = evt.getSource();
            if (source instanceof PortSource) {
                tmp.add((PortSource)source);
                continue;
            }
            log.info("Unsupported event source " + source);
        }
        Iterator it = tmp.iterator();
        int[] lids = new int[tmp.size()];
        short[] ports = new short[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            PortSource ps = (PortSource)it.next();
            lids[i] = ps.getLid();
            ports[i] = ps.getPortNum();
        }
        return new PortUpdateEvent(lids, ports, this);
    }
}

