/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.IBackgroundService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundService
implements IBackgroundService {
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 1000L;
    private final ExecutorService service;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final long timeout;

    public BackgroundService(ExecutorService service) {
        this.service = service;
        this.timeout = 1000L;
    }

    @Override
    public Future<Void> submit(Runnable runnable) {
        BackgroundTask<Void> task;
        block2: {
            Exception e = new Exception("Caller's stack trace");
            task = new BackgroundTask<Void>(runnable, this.shutdown, e);
            try {
                this.service.submit(task);
            }
            catch (RejectedExecutionException ree) {
                if (this.shutdown.get()) break block2;
                throw ree;
            }
        }
        return task;
    }

    @Override
    public <V> Future<V> submit(Callable<V> callable) {
        Exception e = new Exception("Caller's stack trace");
        BackgroundTask<V> task = new BackgroundTask<V>(callable, this.shutdown, e);
        this.service.submit(task);
        return task;
    }

    @Override
    public void shutdown() {
        this.shutdown.set(true);
        this.service.shutdown();
        try {
            this.service.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
            if (!this.service.isTerminated()) {
                this.service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    private class BackgroundTask<V>
    extends FutureTask<V> {
        private final AtomicBoolean shutdown;
        private final Exception clientTrace;

        public BackgroundTask(Callable<V> callable, AtomicBoolean shutdown, Exception clientTrace) {
            super(callable);
            this.shutdown = shutdown;
            this.clientTrace = clientTrace;
        }

        public BackgroundTask(Runnable runnable, AtomicBoolean shutdown, Exception clientTrace) {
            super(runnable, null);
            this.shutdown = shutdown;
            this.clientTrace = clientTrace;
        }

        @Override
        protected void setException(Throwable t) {
            if (this.shutdown.get()) {
                System.out.println("Exception ignored after shutdown: " + t);
            } else {
                if (this.clientTrace != null) {
                    t.addSuppressed(this.clientTrace);
                }
                super.setException(t);
            }
        }
    }
}

