/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.DistributionBarPanel;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.ImageIcon;

public class DistributionBarController {
    private final String[] items;
    private long[] values;
    private long[] cumulativeSum;
    private final Color[] colors;
    private final DistributionBarPanel distributionBar;

    public DistributionBarController(DistributionBarPanel view, String[] items, long[] values, Color[] colors) {
        this.items = items;
        this.colors = colors;
        this.distributionBar = view;
        this.updateValues(values);
        this.check(items, colors);
        this.initBar();
    }

    public DistributionBarPanel getDistributionBar() {
        return this.distributionBar;
    }

    protected void check(String[] names, Color[] colors) {
        if (names == null) {
            throw new IllegalArgumentException("No names for segments");
        }
        if (colors != null && colors.length != names.length) {
            throw new IllegalArgumentException("Invalid argument. Expected " + colors.length + " colors, got " + this.values.length + " colors.");
        }
    }

    protected void check(long[] values, String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("No names for segments");
        }
        if (values != null && values.length != names.length) {
            throw new IllegalArgumentException("Invalid argument. Expected " + names.length + " values, got " + values.length + " values.");
        }
    }

    protected void initBar() {
        ImageIcon[] icons = new ImageIcon[this.colors.length];
        String[] itemLabels = new String[this.colors.length];
        for (int i = 0; i < this.colors.length; ++i) {
            icons[i] = Util.generateImageIcon(this.colors[i], 10, new Insets(1, 1, 1, 1));
            itemLabels[i] = this.getItemLegend(i);
        }
        this.distributionBar.init(itemLabels, icons);
    }

    public void setDistribution(long[] values) {
        this.updateValues(values);
        final String[] itemLabels = new String[this.colors.length];
        for (int i = 0; i < this.colors.length; ++i) {
            itemLabels[i] = this.getItemLegend(i);
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                DistributionBarController.this.distributionBar.update(itemLabels, DistributionBarController.this.cumulativeSum, DistributionBarController.this.colors);
            }
        });
    }

    protected String getItemLegend(int i) {
        if (this.cumulativeSum == null) {
            return STLConstants.K0039_NOT_AVAILABLE.getValue();
        }
        double perentage = (double)this.values[i] / (double)this.cumulativeSum[this.cumulativeSum.length - 1];
        return this.items[i] + " " + this.values[i] + " (" + UIConstants.PERCENTAGE.format(perentage) + ")";
    }

    protected void updateValues(long[] values) {
        this.check(values, this.items);
        this.values = values;
        if (values == null) {
            this.cumulativeSum = null;
        } else {
            int sum = 0;
            this.cumulativeSum = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                sum = (int)((long)sum + values[i]);
                this.cumulativeSum[i] = sum;
            }
        }
    }
}

