/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.IContextAware;
import com.intel.stl.ui.common.IEventSummaryBarListener;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.EventSummaryBarPanel;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.StateSummary;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.IStateChangeListener;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.subscriber.EventSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import java.util.EnumMap;
import java.util.Properties;

public class EventSummaryBarPanelController
implements IContextAware,
IStateChangeListener {
    private static final String NAME = "EventSummaryBar";
    private final EventSummaryBarPanel view;
    private Context context;
    private IEventSummaryBarListener iEventSummaryBarListener;
    private EventSubscriber eventSubscriber;
    private ICallback<StateSummary> stateSummaryCallback;
    private Task<StateSummary> stateSummaryTask;
    private String timingWindow;

    public EventSummaryBarPanelController(EventSummaryBarPanel eventSummaryBarPanel) {
        this.view = eventSummaryBarPanel;
    }

    public void setEventSummaryBarListener(IEventSummaryBarListener iEventSummaryBarListener) {
        this.iEventSummaryBarListener = iEventSummaryBarListener;
        this.view.setEventSummaryBarListener(this.iEventSummaryBarListener);
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        Properties userPreference;
        this.clear();
        this.context = context;
        UserSettings userSettings = this.context.getUserSettings();
        if (userSettings != null && (userPreference = userSettings.getUserPreference()) != null) {
            this.timingWindow = userPreference.getProperty("TimingWindow");
            this.view.setTimingWindow(this.timingWindow);
        }
        this.context.getEvtCal().addListener(this);
        TaskScheduler scheduler = this.context.getTaskScheduler();
        this.eventSubscriber = (EventSubscriber)scheduler.getSubscriber(SubscriberType.EVENT);
        this.stateSummaryCallback = new CallbackAdapter<StateSummary>(){

            @Override
            public synchronized void onDone(StateSummary result) {
                if (result != null) {
                    EventSummaryBarPanelController.this.onStateChange(result);
                }
            }
        };
        this.stateSummaryTask = this.eventSubscriber.registerStateSummary(this.stateSummaryCallback);
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected void processStateSummary(StateSummary stateSummary) {
        String timingWindow;
        Properties userPreference;
        final EnumMap<NoticeSeverity, Integer> states = stateSummary.getStates(null);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                EventSummaryBarPanelController.this.view.updateEventSeverity(states);
            }
        });
        UserSettings userSettings = this.context.getUserSettings();
        if (userSettings != null && (userPreference = userSettings.getUserPreference()) != null && !this.timingWindow.equals(timingWindow = userPreference.getProperty("TimingWindow"))) {
            this.timingWindow = timingWindow;
            this.view.setTimingWindow(this.timingWindow);
        }
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.LOW;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.LOW;
    }

    @Override
    public void onStateChange(StateSummary summary) {
        if (summary != null) {
            this.processStateSummary(summary);
        }
    }

    protected void clear() {
        if (this.context != null && this.context.getEvtCal() != null) {
            this.context.getEvtCal().removeListener(this);
        }
        if (this.eventSubscriber != null && this.stateSummaryTask != null) {
            this.eventSubscriber.deregisterStateSummary(this.stateSummaryTask, this.stateSummaryCallback);
        }
    }

    @Override
    public String toString() {
        return "EventSummaryBarPanelController";
    }
}

