/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class ExComboBoxModel<E>
extends DefaultComboBoxModel<E> {
    private static final long serialVersionUID = 386462244488142481L;
    private final List<E> disabledItems = new ArrayList();
    private final Set<Integer> disabledItemIds = new HashSet<Integer>();
    private final boolean adjustSelection;

    public ExComboBoxModel(boolean adjustSelection) {
        this.adjustSelection = adjustSelection;
    }

    public ExComboBoxModel(E[] items, boolean adjustSelection) {
        super(items);
        this.adjustSelection = adjustSelection;
    }

    public ExComboBoxModel(Vector<E> v, boolean adjustSelection) {
        super(v);
        this.adjustSelection = adjustSelection;
    }

    public void setDisabledItem(E ... items) {
        this.disabledItems.clear();
        this.disabledItemIds.clear();
        if (items == null || items.length == 0) {
            return;
        }
        this.disabledItems.addAll(Arrays.asList(items));
        this.chacheDisabledIndices();
        this.adjustSelection();
    }

    public void addDisabledItem(E item) {
        if (this.disabledItems.contains(item)) {
            return;
        }
        this.disabledItems.add(item);
        int index = this.getIndexOf(item);
        this.disabledItemIds.add(index);
        this.adjustSelection();
    }

    public void removeDisabledItem(E item) {
        if (this.disabledItems.remove(item)) {
            int index = this.getIndexOf(item);
            this.disabledItemIds.remove(index);
        }
    }

    public E getFirstAvailableItem() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.disabledItemIds.contains(i)) continue;
            return this.getElementAt(i);
        }
        return null;
    }

    protected void adjustSelection() {
        if (!this.adjustSelection) {
            return;
        }
        Object selected = this.getSelectedItem();
        if (selected == null) {
            return;
        }
        Object firstAvaiable = null;
        for (E item : this.disabledItems) {
            if (!selected.equals(item)) continue;
            boolean foundDisabledItem = false;
            for (int i = 0; i < this.getSize(); ++i) {
                Object element = this.getElementAt(i);
                if (firstAvaiable == null && !this.disabledItemIds.contains(i)) {
                    firstAvaiable = element;
                }
                if (!foundDisabledItem) {
                    foundDisabledItem = element != null && element.equals(item);
                    continue;
                }
                if (this.disabledItemIds.contains(i)) continue;
                this.setSelectedItem(element);
                return;
            }
            this.setSelectedItem(firstAvaiable);
            return;
        }
    }

    protected void chacheDisabledIndices() {
        this.disabledItemIds.clear();
        for (int i = 0; i < this.getSize(); ++i) {
            Object element = this.getElementAt(i);
            for (E item : this.disabledItems) {
                if (element == null || !element.equals(item)) continue;
                this.disabledItemIds.add(i);
            }
        }
    }

    public boolean isDisabled(int index) {
        return this.disabledItemIds.contains(index);
    }

    @Override
    public void removeElementAt(int index) {
        Object element = this.getElementAt(index);
        this.disabledItems.remove(element);
        super.removeElementAt(index);
        this.chacheDisabledIndices();
    }

    @Override
    public void removeElement(Object anObject) {
        this.disabledItems.remove(anObject);
        super.removeElement(anObject);
        this.chacheDisabledIndices();
    }

    @Override
    public void removeAllElements() {
        this.disabledItems.clear();
        this.disabledItemIds.clear();
        super.removeAllElements();
    }

    public List<E> getDisabledItems() {
        return this.disabledItems;
    }
}

