/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.PinArgument;
import com.intel.stl.ui.performance.ChartArgument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PinDescription {
    private static final String DELIMITER = ";";
    private final PinID id;
    private final String title;
    private int height;
    private PinArgument argument;

    public PinDescription(PinID id, String title) {
        this(id, title, new PinArgument());
    }

    public PinDescription(PinID id, String title, PinArgument argument) {
        this.id = id;
        this.title = title;
        this.argument = argument;
    }

    public void setArgument(PinArgument argument) {
        this.argument = argument;
    }

    public PinID getID() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public PinArgument getArgument() {
        return this.argument;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getDescription() {
        if (this.argument.isEmpty()) {
            return this.title;
        }
        if (this.argument instanceof ChartArgument) {
            return ((ChartArgument)this.argument).getFullName();
        }
        return this.getMetaDescription();
    }

    public String getMetaDescription() {
        if (this.argument.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer("<html><body><table>");
        for (String key : this.argument.stringPropertyNames()) {
            sb.append("<tr><td><b>" + key + "</b></td><td>" + this.argument.getProperty(key) + "</td></tr>");
        }
        sb.append("</table></body></html>");
        return sb.toString();
    }

    public String persistent() {
        if (this.title.contains(DELIMITER)) {
            throw new RuntimeException("Title '" + this.title + "' constains reserved delimiter '" + DELIMITER + "'");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.id.name() + DELIMITER);
        sb.append(this.title + DELIMITER);
        sb.append(Integer.toString(this.height) + DELIMITER);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.argument.store(out, "Argument");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sb.append(out.toString());
        return sb.toString();
    }

    public static PinDescription restore(String str) {
        String[] segs = str.split(DELIMITER, 4);
        if (segs.length != 4) {
            throw new IllegalArgumentException("Invalid PinDescription persistent string '" + str + "'");
        }
        PinID id = PinID.valueOf(segs[0]);
        String title = segs[1];
        PinDescription res = new PinDescription(id, title);
        int height = Integer.parseInt(segs[2]);
        res.setHeight(height);
        PinArgument argument = new PinArgument();
        ByteArrayInputStream in = new ByteArrayInputStream(segs[3].getBytes());
        try {
            argument.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ChartArgument<?> chartArg = null;
        try {
            chartArg = ChartArgument.asChartArgument(argument);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (chartArg != null) {
            res.setArgument(chartArg);
        } else {
            res.setArgument(argument);
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argument == null ? 0 : this.argument.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PinDescription other = (PinDescription)obj;
        if (this.argument == null ? other.argument != null : !this.argument.equals(other.argument)) {
            return false;
        }
        return this.id == other.id;
    }

    public String toString() {
        return "PinDescription [id=" + (Object)((Object)this.id) + ", title=" + this.title + ", argument=" + this.argument + "]";
    }

    public static enum PinID {
        STATUS,
        HEALTH,
        WORST,
        SUBNET_BW,
        SUBNET_PR,
        SUBNET_CG,
        SUBNET_SC,
        SUBNET_SI,
        SUBNET_BB,
        SUBNET_SE,
        SUBNET_RT,
        PERF_BW,
        PERF_PR,
        PERF_CG,
        PERF_SC,
        PERF_SI,
        PERF_BB,
        PERF_SE,
        PERF_RT,
        PERF_PORT,
        PERF_PORT_ERR,
        PERF_NODE;

    }
}

