/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.framework.ITask;

public class ProgressObserver
implements IProgressObserver {
    private final ITask worker;
    private final ProgressObserver parent;
    private final int estimatedWork;
    private double doneWork;

    public ProgressObserver(ITask worker) {
        this(worker, 100);
    }

    public ProgressObserver(ITask worker, int estimatedWork) {
        this(worker, null, estimatedWork);
    }

    public ProgressObserver(ITask worker, ProgressObserver parent, int estimatedWork) {
        if (estimatedWork < 0) {
            throw new IllegalArgumentException("Invalid estimated work value '" + estimatedWork + "'. It must be a positive number");
        }
        this.worker = worker;
        this.parent = parent;
        this.estimatedWork = estimatedWork;
        this.doneWork = 0.0;
    }

    @Override
    public void publishProgress(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Invalid percentage '" + percentage + "'");
        }
        double amountDone = percentage * (double)this.estimatedWork;
        double amountToPublish = amountDone - this.doneWork;
        this.reportProgress(amountToPublish);
    }

    protected void reportProgress(double amount) {
        this.doneWork += amount;
        if (this.parent != null) {
            this.parent.reportProgress(amount);
            return;
        }
        this.worker.firePropertyChange("ProgressAmount", null, new Double(amount));
    }

    @Override
    public void publishNote(String note) {
        this.worker.firePropertyChange("ProgressNote", null, note);
    }

    @Override
    public boolean isCancelled() {
        if (this.worker != null) {
            return this.worker.isCancelled();
        }
        return false;
    }

    @Override
    public void onFinish() {
        this.publishProgress(1.0);
    }

    @Override
    public IProgressObserver[] createSubObservers(int size) {
        IProgressObserver[] res = new IProgressObserver[size];
        int workToBeDone = this.estimatedWork - (int)this.doneWork;
        int step = workToBeDone > size ? Math.round((float)workToBeDone / (float)size) : 1;
        for (int i = 0; i < size; ++i) {
            if (workToBeDone > step) {
                workToBeDone -= step;
            } else {
                step = workToBeDone;
            }
            res[i] = new ProgressObserver(this.worker, this, step);
        }
        return res;
    }

    public static IProgressObserver emptyObserver() {
        return new ProgressObserver(null);
    }
}

