/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.view.DialogFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    private static final String UNDO_ACTION = "UNDO";
    private static final String REDO_ACTION = "REDO";

    public static ImageIcon getImageIcon(String path) {
        URL loc;
        if (path != null && (loc = Util.class.getResource(path)) != null) {
            return new ImageIcon(loc);
        }
        return null;
    }

    public static ImageIcon generateImageIcon(Color color, int size, Insets insets) {
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(color);
        if (insets != null) {
            g2d.fillRect(insets.left, insets.top, size - insets.left - insets.right, size - insets.top - insets.bottom);
        }
        g2d.dispose();
        return new ImageIcon(image);
    }

    public static String truncateString(String source, int prefixLength, int totalLength) {
        if (source.length() <= totalLength) {
            return source;
        }
        if (prefixLength + 3 > totalLength) {
            throw new IllegalArgumentException("total length meust be larger than prefix length + 3!");
        }
        int tokeep = totalLength - prefixLength - 3;
        return source.substring(0, prefixLength) + "..." + source.substring(source.length() - tokeep, source.length());
    }

    public static String addSpaceBetText(String str1, int space, String str2) {
        char[] padded = new char[str1.length() + space];
        Arrays.fill(padded, ' ');
        str1.getChars(0, str1.length(), padded, 0);
        return new String(padded) + str2;
    }

    public static String getFuzzKey(String pattern, Collection<String> keys) {
        if (pattern == null || keys == null || keys.isEmpty()) {
            return null;
        }
        MessageFormat format = new MessageFormat(pattern);
        for (String key : keys) {
            try {
                format.parse(key);
                return key;
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static boolean matchPattern(String pattern, String test) {
        MessageFormat format = new MessageFormat(pattern);
        try {
            format.parse(test);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static int[] toPrimitive(Integer[] IntArray) {
        int[] intArray = new int[IntArray.length];
        for (int i = 0; i < IntArray.length; ++i) {
            intArray[i] = IntArray[i];
        }
        return intArray;
    }

    public static Point adjustPoint(Rectangle desired, Window owner) {
        GraphicsDevice[] gds;
        Rectangle curScreen;
        Point res;
        if (owner != null && (res = Util.adjustPoint(desired, curScreen = owner.getGraphicsConfiguration().getBounds())) != null) {
            return res;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            Rectangle bounds = gd.getDefaultConfiguration().getBounds();
            Point res2 = Util.adjustPoint(desired, bounds);
            if (res2 == null) continue;
            return res2;
        }
        return new Point(desired.x, desired.y);
    }

    private static Point adjustPoint(Rectangle desired, Rectangle curScreen) {
        Point startPoint = new Point(desired.x, desired.y);
        Point endPoint = new Point(desired.x + desired.width, desired.y + desired.height);
        if (curScreen.contains(desired)) {
            return startPoint;
        }
        if (curScreen.contains(startPoint)) {
            if (endPoint.x > curScreen.x + curScreen.width) {
                startPoint.x = curScreen.x + curScreen.width - desired.width;
            }
            if (endPoint.y > curScreen.y + curScreen.height) {
                startPoint.y = curScreen.y + curScreen.height - desired.height;
            }
            return startPoint;
        }
        return null;
    }

    public static void showErrorMessage(final Component parent, final String message) {
        log.error("Show Error Message on Dialog", (Throwable)new Exception(message));
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                DialogFactory.showErrorDialog(parent, message);
            }
        });
    }

    public static void showError(final Component parent, final Throwable e) {
        log.error("Show Error Message on Dialog", e);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                DialogFactory.showErrorDialog(parent, e);
            }
        });
    }

    public static void showErrors(final Component parent, final Collection<? extends Throwable> e) {
        for (Throwable throwable : e) {
            log.error("Show Error Message on Dialog", throwable);
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                DialogFactory.showErrorDialog(parent, e);
            }
        });
    }

    public static void showWarningMessage(Component parent, final String message) {
        log.warn("Show Warning Message on Dialog", (Throwable)new Exception(message));
        final Component root = parent == null ? null : SwingUtilities.getRoot(parent);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                DialogFactory.showWarningDialog(root, message);
            }
        });
    }

    public static int showConfirmDialog(Component parent, String message) {
        Component root = parent == null ? null : SwingUtilities.getRoot(parent);
        return DialogFactory.showConfirmDialog(root, message);
    }

    public static void makeUndoable(JTextComponent comp) {
        final UndoManager undoMgr = new UndoManager();
        comp.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undoMgr.addEdit(evt.getEdit());
            }
        });
        comp.getActionMap().put(UNDO_ACTION, new AbstractAction(UNDO_ACTION){
            private static final long serialVersionUID = 6916362113277049438L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoMgr.canUndo()) {
                        undoMgr.undo();
                    }
                }
                catch (CannotUndoException e) {
                    e.printStackTrace();
                }
            }
        });
        comp.getActionMap().put(REDO_ACTION, new AbstractAction(REDO_ACTION){
            private static final long serialVersionUID = 1905302135550403038L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoMgr.canRedo()) {
                        undoMgr.redo();
                    }
                }
                catch (CannotRedoException e) {
                    e.printStackTrace();
                }
            }
        });
        comp.getInputMap().put(KeyStroke.getKeyStroke(90, 128), UNDO_ACTION);
        comp.getInputMap().put(KeyStroke.getKeyStroke(89, 128), REDO_ACTION);
    }

    public static final DateFormat getYYMMDD() {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static final DateFormat getHHMMSS() {
        return new SimpleDateFormat("HH:mm:ss");
    }

    public static final DateFormat getYYYYMMDDHHMMSS() {
        return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a, z");
    }

    public static final String extractCommand(String cmd, String prompt) {
        String[] commands = cmd.split(Pattern.quote(prompt));
        String command = null;
        if (commands.length > 1) {
            String commandLine = commands[1];
            commandLine = commandLine.trim();
            command = commandLine.split(" ")[0];
        }
        return command;
    }

    public static final void dumpComponent(Component comp, String prefix, PrintStream out) {
        Component[] children;
        out.println(prefix + comp.getName() + " " + comp);
        if (comp instanceof Container && (children = ((Container)comp).getComponents()) != null && children.length > 0) {
            prefix = "  " + prefix;
            for (Component child : children) {
                Util.dumpComponent(child, prefix, out);
            }
        }
    }
}

