/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.model.ChartGroup;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class ChartsSectionView
extends JSectionView<ISectionListener> {
    private static final long serialVersionUID = -2957418754040069251L;
    private final List<TabTitle> titles = new ArrayList<TabTitle>();
    private JPanel mainPanel;
    private TabbedPanel[] groupPanels;
    private ChangeListener listener;

    public ChartsSectionView(String title) {
        super(title);
        this.getMainComponent();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        }
        return this.mainPanel;
    }

    public void setChartGroups(ChartGroup[] groups) {
        this.installChartsViews(this.mainPanel, groups);
    }

    protected void installChartsViews(JPanel panel, ChartGroup[] chartsGroups) {
        this.setLayout(panel);
        this.groupPanels = new TabbedPanel[chartsGroups.length];
        for (int i = 0; i < chartsGroups.length; ++i) {
            this.groupPanels[i] = this.createTabbedPane(chartsGroups[i]);
            panel.add(this.groupPanels[i]);
        }
    }

    protected void setLayout(JPanel mainPanel) {
        mainPanel.setLayout(new GridLayout(1, 4, 5, 5));
    }

    protected TabbedPanel createTabbedPane(ChartGroup chartsGroup) {
        if (chartsGroup == null || !chartsGroup.hasMembers()) {
            throw new IllegalArgumentException("ChartGroup cannot be null and it must have members");
        }
        TabbedPanel panel = new TabbedPanel();
        panel.setName(chartsGroup.getName());
        if (this.listener != null) {
            panel.setListener(this.listener);
        }
        List<ChartGroup> members = chartsGroup.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            ChartGroup member = members.get(i);
            Component component = this.createGroupPanel(member);
            TabTitle title = new TabTitle(panel, member.getName(), member.getChartView());
            panel.addTab(member.getName(), title, component);
            this.titles.add(title);
        }
        return panel;
    }

    protected Component createGroupPanel(ChartGroup group) {
        if (group == null || !group.hasMembers()) {
            throw new IllegalArgumentException("ChartGroup cannot be null and it must have members");
        }
        JPanel panel = new JPanel(new GridLayout(1, group.numMembers(), 5, 5));
        List<ChartGroup> members = group.getMembers();
        for (ChartGroup member : members) {
            ChartsView view = member.getChartView();
            view.setPreferredSize(new Dimension(270, 250));
            panel.add(view);
        }
        return panel;
    }

    public void setListener(ChangeListener listener) {
        this.listener = listener;
        if (this.groupPanels != null) {
            for (TabbedPanel panel : this.groupPanels) {
                panel.setListener(listener);
            }
        }
    }

    class TabTitle
    extends JPanel {
        private static final long serialVersionUID = 268393669119889498L;
        private final TabbedPanel parent;
        private final String name;
        private final String sparkline;
        private final ChartsView chartsView;
        private ChartPanel chartPanel;
        private JLabel title;
        private JFreeChart chart;
        private boolean isSelected;

        public TabTitle(TabbedPanel parent, String name, ChartsView chartsView) {
            this.parent = parent;
            this.name = name;
            this.sparkline = chartsView.getTitle();
            this.chartsView = chartsView;
            this.initComponent();
            this.setSelected(this.isSelected);
            this.update();
        }

        protected void initComponent() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createMatteBorder(0, 2, 1, 2, UIConstants.INTEL_WHITE));
            this.title = ComponentFactory.getH4Label(this.name, 1);
            this.title.setHorizontalAlignment(0);
            this.title.setBackground(UIConstants.INTEL_WHITE);
            this.title.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
            this.add((Component)this.title, "South");
            this.chartPanel = new ChartPanel(null);
            this.chartPanel.setPreferredSize(new Dimension(60, 20));
            this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TabTitle.this.parent.select(TabTitle.this.name);
                }
            });
            this.add((Component)this.chartPanel, "Center");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TabTitle.this.parent.select(TabTitle.this.name);
                }
            });
        }

        protected void update() {
            this.chart = this.chartsView.getSparkline(this.sparkline);
            if (this.chart == null) {
                return;
            }
            this.chartPanel.setChart(this.chart);
            if (this.isSelected) {
                this.chart.setBackgroundPaint((Paint)UIConstants.INTEL_WHITE);
            } else {
                this.chart.setBackgroundPaint((Paint)new Color(240, 240, 240, 0));
            }
        }

        public void setSelected(boolean b) {
            this.isSelected = b;
            if (b) {
                this.title.setOpaque(true);
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                if (this.chart != null) {
                    this.chart.setBackgroundPaint((Paint)UIConstants.INTEL_WHITE);
                }
            } else {
                this.title.setOpaque(false);
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createLineBorder(UIConstants.INTEL_GRAY)));
                if (this.chart != null) {
                    this.chart.setBackgroundPaint((Paint)new Color(240, 240, 240, 0));
                }
            }
        }
    }

    public class TabbedPanel
    extends JPanel {
        private static final long serialVersionUID = -1113934752788733902L;
        private JPanel tabPanel;
        private CardLayout layout;
        private JPanel titlePanel;
        private final LinkedHashMap<String, TabTitle> titles = new LinkedHashMap();
        private Component padPanel;
        private GridBagConstraints gc;
        private String previousSelection;
        private String selection;
        private ChangeListener listener;

        public TabbedPanel() {
            this.initComponent();
        }

        private void initComponent() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.layout = new CardLayout();
            this.tabPanel = new JPanel(this.layout);
            this.tabPanel.setBorder(BorderFactory.createMatteBorder(3, 3, 5, 3, UIConstants.INTEL_WHITE));
            this.add((Component)this.tabPanel, "Center");
            this.titlePanel = new JPanel(new GridBagLayout());
            this.titlePanel.setOpaque(false);
            this.gc = new GridBagConstraints();
            this.gc.fill = 1;
            this.gc.weightx = 0.0;
            this.gc.weighty = 0.0;
            this.gc.gridwidth = 1;
            this.padPanel = Box.createHorizontalGlue();
            this.titlePanel.add(this.padPanel);
            this.add((Component)this.titlePanel, "South");
        }

        public void addTab(String name, TabTitle title, Component content) {
            this.tabPanel.add(name, content);
            this.titlePanel.remove(this.padPanel);
            this.gc.weightx = 0.0;
            this.titlePanel.add((Component)title, this.gc);
            this.gc.weightx = 1.0;
            this.titlePanel.add(this.padPanel, this.gc);
            this.titles.put(name, title);
            if (this.selection == null) {
                this.select(name);
            }
        }

        public void select(String name) {
            TabTitle tab;
            if (this.selection != null && (tab = this.titles.get(this.selection)) != null) {
                tab.setSelected(false);
            }
            if ((tab = this.titles.get(name)) != null) {
                tab.setSelected(true);
            }
            this.layout.show(this.tabPanel, name);
            this.previousSelection = this.selection;
            this.selection = name;
            if (this.listener != null) {
                this.listener.stateChanged(new ChangeEvent(this));
            }
        }

        public String getSelection() {
            return this.selection;
        }

        public String getPreviousSelection() {
            return this.previousSelection;
        }

        public void setListener(ChangeListener listener) {
            this.listener = listener;
        }
    }
}

