/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.MovingTogether;
import com.intel.stl.ui.main.view.FVMainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DialogBuilder {
    private String title;
    private JDialog dialog;
    private JPanel buttonsPanel;
    private JTextArea text;
    private JScrollPane jspane;
    private JLabel dialogIconLbl;
    private final Color bgColor = UIConstants.INTEL_WHITE;
    private JButton okBtn;
    private JButton cancelBtn;
    private int btnPressed = 1;
    private int lastCaretPosition = 0;

    public DialogBuilder(Component owner, String title, boolean modal, String btn0) {
        this(owner, title, modal, btn0, null);
    }

    public DialogBuilder(String btn0) {
        this.dialog = new JDialog();
        this.createButtonsPanel(btn0, null);
        this.initComponents();
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModalityType(Dialog.ModalityType.MODELESS);
        this.dialog.setIconImage(UIImages.LOGO_24.getImage());
        this.dialog.setPreferredSize(new Dimension(500, 300));
        this.dialog.pack();
    }

    public DialogBuilder(Component owner, String title, boolean modal, String btn0, String btn1) {
        this.title = title;
        if (owner instanceof JFrame) {
            this.dialog = new JDialog((JFrame)owner, title, modal);
            new MovingTogether((JFrame)owner, this.dialog);
        } else if (owner instanceof JDialog) {
            this.dialog = new JDialog((JDialog)owner, title, modal);
        } else {
            this.dialog = new JDialog();
            this.dialog.setTitle(title);
            this.dialog.setModal(modal);
            this.dialog.setIconImage(UIImages.LOGO_24.getImage());
        }
        this.createButtonsPanel(btn0, btn1);
        this.initComponents();
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setPreferredSize(new Dimension(500, 300));
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(owner);
    }

    public DialogBuilder(Component owner, String title, boolean modal, Component showThisInDialog, String btn0, String btn1) {
        this.title = title;
        if (owner instanceof JFrame) {
            this.dialog = new JDialog((JFrame)owner, title, modal);
            new MovingTogether((JFrame)owner, this.dialog);
            if (modal) {
                this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            }
        } else if (owner instanceof JDialog) {
            this.dialog = new JDialog((JDialog)owner, title, modal);
        } else {
            this.dialog = new JDialog();
            this.dialog.setTitle(title);
            this.dialog.setModal(modal);
            this.dialog.setIconImage(UIImages.LOGO_24.getImage());
        }
        this.createButtonsPanel(btn0, btn1);
        this.dialog.setDefaultCloseOperation(2);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        content.add(showThisInDialog, "Center");
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        content.add((Component)this.buttonsPanel, "South");
        this.dialog.getContentPane().add(content);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(owner);
    }

    public void initComponents() {
        Container container = this.dialog.getContentPane();
        container.setBackground(this.bgColor);
        container.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.dialogIconLbl = new JLabel();
        gc.insets = new Insets(20, 20, 20, 20);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        gc.fill = 2;
        gc.anchor = 18;
        container.add((Component)this.dialogIconLbl, gc);
        this.jspane = new JScrollPane(this.getTextArea(), 20, 31);
        this.jspane.setBorder(BorderFactory.createEmptyBorder());
        this.jspane.getVerticalScrollBar().setPreferredSize(new Dimension(10, 0));
        JViewport viewport = this.jspane.getViewport();
        viewport.setScrollMode(1);
        gc.insets = new Insets(20, 0, 20, 10);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridwidth = 0;
        gc.fill = 1;
        container.add((Component)this.jspane, gc);
        gc.insets = new Insets(0, 0, 5, 5);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 0;
        gc.fill = 2;
        container.add((Component)this.buttonsPanel, gc);
    }

    protected void createButtonsPanel(String btn0, String btn1) {
        this.buttonsPanel = new JPanel(new FlowLayout(4));
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.buttonsPanel.setOpaque(false);
        if (btn1 != null) {
            this.cancelBtn = ComponentFactory.getIntelCancelButton(btn1);
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogBuilder.this.cancelAction();
                }
            });
            this.buttonsPanel.add(this.cancelBtn);
        }
        if (btn0 != null) {
            this.okBtn = ComponentFactory.getIntelActionButton(btn0);
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogBuilder.this.text != null) {
                        DialogBuilder.this.text.setText(null);
                    }
                    DialogBuilder.this.btnPressed = 0;
                    DialogBuilder.this.dialog.dispose();
                }
            });
            this.buttonsPanel.add(this.okBtn);
        }
        if (btn0 != null && btn1 != null) {
            JButton[] btnGroup = new JButton[]{this.okBtn, this.cancelBtn};
            ComponentFactory.makeSameWidthButtons(btnGroup);
        }
    }

    public void show() {
        this.refresh();
        if (!this.dialog.isVisible()) {
            if (this.dialog.getParent() != null && this.dialog.getParent() instanceof JFrame) {
                JFrame parent = (JFrame)this.dialog.getParent();
                if (parent.getState() != 0) {
                    parent.setState(0);
                }
                parent.setVisible(true);
                parent.toFront();
            }
            this.dialog.setLocationRelativeTo(this.dialog.getParent());
            this.dialog.setVisible(true);
        }
    }

    protected void refresh() {
        Container parent = this.dialog.getParent();
        if (parent != null) {
            String prefix = null;
            if (parent instanceof FVMainFrame) {
                prefix = ((FVMainFrame)parent).getSubnetName();
            } else if (parent instanceof Frame) {
                prefix = ((Frame)parent).getTitle();
            } else if (parent instanceof Dialog) {
                prefix = ((Dialog)parent).getTitle();
            }
            if (prefix != null) {
                this.dialog.setTitle(prefix + " " + this.title);
            }
        }
    }

    public int getButtonPressed() {
        return this.btnPressed;
    }

    public void cancelAction() {
        this.btnPressed = 1;
        this.dialog.setVisible(false);
    }

    private JTextArea getTextArea() {
        this.text = new JTextArea();
        this.text.setEditable(false);
        PlainDocument plaindocument = new PlainDocument();
        this.text.setDocument(plaindocument);
        this.text.revalidate();
        this.text.setMargin(new Insets(0, 10, 0, 0));
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.text.setRows(0);
        return this.text;
    }

    public void appendText(String str) {
        int currentCaretPosition = this.lastCaretPosition;
        if (this.text.getText().isEmpty()) {
            this.text.append(str);
        } else {
            this.text.append("\n" + str);
            ++currentCaretPosition;
        }
        this.lastCaretPosition = this.text.getText().length();
        this.text.setCaretPosition(currentCaretPosition);
        try {
            Rectangle viewableArea = this.text.modelToView(this.text.getCaretPosition());
            this.text.scrollRectToVisible(viewableArea);
            this.jspane.getViewport().setViewPosition(new Point(viewableArea.x, viewableArea.y));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setImageIcon(ImageIcon dlgIcon) {
        this.dialogIconLbl.setIcon(dlgIcon);
    }

    public void setText(String str) {
        this.text.setText(str);
    }
}

