/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.DialogBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogFactory {
    private static final Logger log = LoggerFactory.getLogger(DialogFactory.class);
    private static ImageIcon INFO_ICON = UIImages.LOGO_64.getImageIcon();
    private static ImageIcon CONFIRM_ICON = UIImages.CONFIRM_DLG.getImageIcon();
    private static ImageIcon WARNING_ICON = UIImages.WARNING_DLG.getImageIcon();
    private static ImageIcon ERROR_ICON = UIImages.ERROR_DLG.getImageIcon();
    public static int OK_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    private static Map<Component, DialogBuilder> errorDialogs = new HashMap<Component, DialogBuilder>();

    public static int showConfirmDialog(Component owner, String msg) {
        DialogBuilder infoDialog = new DialogBuilder(owner, STLConstants.K0671_CONFIRM.getValue(), true, STLConstants.K0645_OK.getValue(), STLConstants.K0621_CANCEL.getValue());
        infoDialog.appendText(msg);
        infoDialog.setImageIcon(CONFIRM_ICON);
        infoDialog.getDialog().setVisible(true);
        return infoDialog.getButtonPressed();
    }

    public static void showInfoDialog(Component owner, String msg) {
        DialogBuilder infoDialog = new DialogBuilder(owner, STLConstants.K0032_INFORMATIONAL.getValue(), true, STLConstants.K0645_OK.getValue());
        infoDialog.appendText(msg);
        infoDialog.setImageIcon(INFO_ICON);
        infoDialog.getDialog().setVisible(true);
    }

    public static void showWarningDialog(Component owner, String msg) {
        DialogBuilder warningDialog = new DialogBuilder(owner, STLConstants.K0031_WARNING.getValue(), true, STLConstants.K0645_OK.getValue());
        warningDialog.appendText(msg);
        warningDialog.setImageIcon(WARNING_ICON);
        warningDialog.getDialog().setVisible(true);
    }

    public static void showErrorDialog(Component comp, String errorString) {
        if (errorString != null && !errorString.isEmpty()) {
            DialogBuilder dlg = DialogFactory.getDialogBuilder(comp);
            dlg.appendText(errorString);
            dlg.show();
        }
    }

    public static void showErrorDialog(Component comp, Throwable e) {
        DialogFactory.showErrorDialog(comp, Collections.singletonList(e));
    }

    public static void showErrorDialog(Component comp, Collection<? extends Throwable> errors) {
        DialogBuilder dlg = DialogFactory.getDialogBuilder(comp);
        DialogFactory.showErrors(dlg, errors);
    }

    public static void showModalErrorDialog(Component comp, Collection<? extends Throwable> errors) {
        Component root = comp == null ? null : SwingUtilities.getRoot(comp);
        DialogBuilder dlg = new DialogBuilder(root, STLConstants.K0030_ERROR.getValue(), true, STLConstants.K0645_OK.getValue(), null);
        dlg.setImageIcon(ERROR_ICON);
        dlg.getDialog().setAlwaysOnTop(true);
        DialogFactory.showErrors(dlg, errors);
    }

    /*
     * WARNING - void declaration
     */
    private static void showErrors(DialogBuilder dlg, Collection<? extends Throwable> errors) {
        boolean toShow = false;
        for (Throwable throwable : errors) {
            void var4_4;
            if (throwable instanceof ExecutionException) {
                Throwable throwable2 = ((ExecutionException)throwable).getCause();
            }
            if (var4_4 instanceof InterruptedException) continue;
            if (var4_4 instanceof NullPointerException) {
                log.error("Null Pointer", (Throwable)var4_4);
                continue;
            }
            String errorString = StringUtils.getErrorMessage((Throwable)var4_4);
            dlg.appendText(errorString);
            if (toShow) continue;
            toShow = true;
        }
        if (toShow) {
            dlg.show();
        }
    }

    private static DialogBuilder getDialogBuilder(Component comp) {
        if (comp == null) {
            DialogBuilder errorDialog = new DialogBuilder(STLConstants.K0645_OK.getValue());
            errorDialog.setImageIcon(ERROR_ICON);
            errorDialog.setTitle(STLConstants.K0030_ERROR.getValue());
            return errorDialog;
        }
        Component root = SwingUtilities.getRoot(comp);
        DialogBuilder dlg = errorDialogs.get(root);
        if (dlg == null || !dlg.getDialog().isShowing()) {
            dlg = new DialogBuilder(root, STLConstants.K0030_ERROR.getValue(), false, STLConstants.K0645_OK.getValue(), null);
            dlg.setImageIcon(ERROR_ICON);
            errorDialogs.put(root, dlg);
        }
        return dlg;
    }

    public static int showPasswordDialog(Component owner, String title, Component contentPanel) {
        DialogBuilder passwordDialog = new DialogBuilder(owner, title, true, contentPanel, STLConstants.K0645_OK.getValue(), STLConstants.K0621_CANCEL.getValue());
        passwordDialog.getDialog().setVisible(true);
        return passwordDialog.getButtonPressed();
    }
}

