/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.IEventSummaryBarListener;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.model.NoticeSeverityViz;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSummaryBarPanel
extends JPanel {
    private static final long serialVersionUID = 1457639937923618304L;
    private static Logger log = LoggerFactory.getLogger(EventSummaryBarPanel.class);
    private final EnumMap<NoticeSeverity, LabelPanel> severityPanelList = new EnumMap(NoticeSeverity.class);
    private final GridBagLayout severityPanelGridBagLayout = new GridBagLayout();
    private final GridBagConstraints severityPanelConstraints = new GridBagConstraints();
    private MouseListener panelMouseListener = null;
    private IEventSummaryBarListener iEventSummaryBarListener = null;
    private JPanel titlePanel;
    private String timingWindow;

    public EventSummaryBarPanel() {
        this.initialize();
    }

    public void setEventSummaryBarListener(IEventSummaryBarListener iEventSummary) {
        this.iEventSummaryBarListener = iEventSummary;
        this.installActionListener();
        this.initializeEventSeverity();
    }

    private void installActionListener() {
        this.panelMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EventSummaryBarPanel.this.iEventSummaryBarListener.toggleEventSummaryTable();
            }
        };
    }

    public void initialize() {
        this.setLayout(this.severityPanelGridBagLayout);
        this.setBackground(UIConstants.INTEL_WHITE);
    }

    public void initializeEventSeverity() {
        this.titlePanel = new JPanel();
        JLabel titleLabel = ComponentFactory.getH4Label(STLConstants.K0128_NODES_DISTR_SEVERITY.getValue(), 1);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 5, 2, 0);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        this.titlePanel.add((Component)titleLabel, constraints);
        this.titlePanel.addMouseListener(this.panelMouseListener);
        this.severityPanelConstraints.weighty = 0.0;
        this.addToEventSummaryBarPane(this.titlePanel);
        NoticeSeverity[] array = NoticeSeverity.values();
        for (int i = array.length - 1; 0 <= i; --i) {
            LabelPanel panel = new LabelPanel(array[i]);
            panel.addMouseListener(this.panelMouseListener);
            this.severityPanelList.put(array[i], panel);
            this.severityPanelConstraints.weighty = 0.0;
            this.addToEventSummaryBarPane(panel);
        }
        this.severityPanelConstraints.weighty = 1.0;
        this.severityPanelConstraints.fill = 1;
        this.add(Box.createGlue(), this.severityPanelConstraints);
        this.revalidate();
    }

    public void updateEventSeverity(EnumMap<NoticeSeverity, Integer> countMap) {
        this.titlePanel.setToolTipText(UILabels.STL10008_NODES_DISTR_SEVERITY.getDescription(this.timingWindow));
        for (NoticeSeverity severity : countMap.keySet()) {
            LabelPanel panel = this.severityPanelList.get((Object)severity);
            JLabel countLabel = panel.getCountLabel();
            countLabel.setText(UIConstants.INTEGER.format(countMap.get((Object)severity)));
        }
    }

    public void addToEventSummaryBarPane(JPanel panel) {
        this.severityPanelConstraints.weightx = 1.0;
        this.severityPanelConstraints.fill = 2;
        this.severityPanelConstraints.gridwidth = 0;
        this.severityPanelGridBagLayout.setConstraints(panel, this.severityPanelConstraints);
        this.add((Component)panel, this.severityPanelConstraints);
    }

    public void setTimingWindow(String timingWindow) {
        this.timingWindow = timingWindow;
    }

    private class LabelPanel
    extends JPanel {
        private static final long serialVersionUID = -2905931691586163645L;
        private JLabel nameLabel;
        private final JLabel countLabel;
        private final JPanel countNamePanel;
        private JLabel iconLabel;
        private final GridBagLayout gridBagLayout = new GridBagLayout();
        private final GridBagConstraints constraints = new GridBagConstraints();

        public LabelPanel(NoticeSeverity severity) {
            this.setLayout(new BorderLayout(5, 2));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.setBackground(UIConstants.INTEL_WHITE);
            this.countNamePanel = new JPanel(this.gridBagLayout);
            this.countNamePanel.setBackground(UIConstants.INTEL_WHITE);
            this.countLabel = ComponentFactory.getH2Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 1);
            NoticeSeverityViz sevViz = NoticeSeverityViz.getNoticeSeverityVizFor(severity);
            if (sevViz != null) {
                this.iconLabel = new JLabel(sevViz.getIcon().getImageIcon(), 4);
                this.countLabel.setForeground(sevViz.getColor());
                this.nameLabel = ComponentFactory.getH4Label(sevViz.getName(), 0);
            }
            if (this.nameLabel != null) {
                this.nameLabel.setHorizontalAlignment(2);
            }
            this.gridBagLayout.setConstraints(this.countNamePanel, this.constraints);
            this.constraints.insets = new Insets(2, 5, 2, 0);
            this.constraints.anchor = 13;
            this.constraints.fill = 0;
            this.countNamePanel.add((Component)this.countLabel, this.constraints);
            this.constraints.weightx = 1.0;
            this.constraints.gridwidth = 0;
            this.constraints.anchor = 16;
            this.countNamePanel.add((Component)this.nameLabel, this.constraints);
            this.add((Component)this.iconLabel, "West");
            this.add((Component)this.countNamePanel, "Center");
        }

        public JLabel getCountLabel() {
            return this.countLabel;
        }

        public JLabel getNameLabel() {
            return this.nameLabel;
        }
    }
}

