/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JFormattedTextField;

public class FormattedComboBoxEditor
implements ComboBoxEditor {
    private final JFormattedTextField textField;

    public FormattedComboBoxEditor(JFormattedTextField textField) {
        this.textField = textField;
        textField.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, UIConstants.INTEL_GRAY));
    }

    @Override
    public Component getEditorComponent() {
        return this.textField;
    }

    @Override
    public void setItem(Object anObject) {
        try {
            String newText = this.textField.getFormatter().valueToString(anObject);
            if (!newText.equals(this.textField.getText())) {
                this.textField.setText(newText);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getItem() {
        String text = this.textField.getText();
        try {
            return this.textField.getFormatter().stringToValue(text);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void selectAll() {
        this.textField.selectAll();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.textField.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.textField.removeActionListener(l);
    }
}

