/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1931660137919651275L;
    private final Image image;
    private final Style style;

    public ImagePanel(Image image, Style style) {
        this.image = image;
        this.style = style;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.style == Style.FIT_IMAGE) {
            return new Dimension(this.getImageDesiredWidth(), this.getImageDesiredHeight());
        }
        if (this.style == Style.FIT_IMAGE_WIDTH) {
            return new Dimension(this.getImageDesiredWidth(), super.getPreferredSize().height);
        }
        if (this.style == Style.FIT_IMAGE_HEIGHT) {
            return new Dimension(super.getPreferredSize().width, this.getImageDesiredHeight());
        }
        return super.getPreferredSize();
    }

    protected int getImageDesiredWidth() {
        Insets insets = this.getInsets();
        int w = insets.left + this.image.getWidth(null) + insets.right;
        return w;
    }

    protected int getImageDesiredHeight() {
        Insets insets = this.getInsets();
        int h = insets.top + this.image.getHeight(null) + insets.bottom;
        return h;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Insets insets = this.getInsets();
        switch (this.style) {
            case FIT_PANEL: {
                Dimension size = this.getSize();
                int width = (int)size.getWidth() - insets.left - insets.right;
                int height = (int)size.getHeight() - insets.top - insets.bottom;
                g2d.drawImage(this.image, insets.left, insets.top, width, height, this);
            }
            case FIT_PANEL_WIDTH: {
                Dimension size = this.getSize();
                int width = (int)size.getWidth() - insets.left - insets.right;
                double scale = (double)width / (double)this.image.getWidth(this);
                int height = (int)(scale * (double)this.image.getHeight(this));
                g2d.drawImage(this.image, insets.left, insets.top, width, height, this);
            }
            case FIT_PANEL_HEIGHT: {
                Dimension size = this.getSize();
                int height = (int)size.getHeight() - insets.top - insets.bottom;
                double scale = (double)height / (double)this.image.getHeight(this);
                int width = (int)(scale * (double)this.image.getWidth(this));
                g2d.drawImage(this.image, insets.left, insets.top, width, height, this);
            }
            case FIXED: 
            case FIT_IMAGE: 
            case FIT_IMAGE_WIDTH: 
            case FIT_IMAGE_HEIGHT: {
                g2d.drawImage(this.image, insets.left, insets.top, this);
            }
        }
    }

    public static enum Style {
        FIT_PANEL,
        FIT_PANEL_WIDTH,
        FIT_PANEL_HEIGHT,
        FIXED,
        FIT_IMAGE,
        FIT_IMAGE_WIDTH,
        FIT_IMAGE_HEIGHT;

    }
}

