/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;

public class JHorizontalBar
extends JLabel {
    private static final long serialVersionUID = 3695428455610236209L;
    private double normalizedValue;
    private double upperMargin = 0.25;
    private double lowerMargin = 0.25;

    public JHorizontalBar() {
        this.setOpaque(true);
    }

    public double getNormalizedValue() {
        return this.normalizedValue;
    }

    public void setNormalizedValue(double normalizedValue) {
        this.check(normalizedValue);
        this.normalizedValue = normalizedValue;
        this.repaint();
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double upperMargin) {
        this.check(upperMargin);
        this.upperMargin = upperMargin;
        this.repaint();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double lowerMargin) {
        this.check(lowerMargin);
        this.lowerMargin = lowerMargin;
        this.repaint();
    }

    protected void check(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Value " + value + " is not in range [0, 1]");
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        g.setColor(this.getForeground());
        int w = (int)((double)(this.getWidth() - insets.left - insets.right) * this.normalizedValue);
        int height = this.getHeight() - insets.top - insets.bottom;
        int y = insets.top + (int)((double)height * this.upperMargin);
        int h = (int)((double)height * (1.0 - this.upperMargin - this.lowerMargin));
        if (h > 0 && w > 0) {
            g.fillRect(insets.left, y, w, h);
        }
    }
}

