/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ButtonPopup;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.ExJXList;
import com.intel.stl.ui.common.view.IChartCreator;
import com.intel.stl.ui.main.view.IDataTypeListener;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.HistoryType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class OptionChartsView
extends ChartsView {
    private static final long serialVersionUID = 3144008795121961486L;
    private ExJXList<DataType> dataTypeList;
    private ExJXList<HistoryType> historyTypeList;
    private IDataTypeListener<DataType> groupInfoTypeListener;
    private IDataTypeListener<HistoryType> historyTypeListener;
    private MouseListener groupInfoTypeListSelectionListener;
    private MouseListener historyTypeListSelectionListener;
    private JButton dataTypeBtn;
    private JButton historyTypeBtn;
    private ButtonPopup dataPopupOptions;
    private ButtonPopup historyPopupOptions;
    private DataType dataType;
    private DataType prevDataType;
    private HistoryType historyType;
    private HistoryType prevHistoryType;
    private JComponent ctrPanel;
    private JToolBar toolBar;

    public OptionChartsView(String title, IChartCreator chartCreator) {
        super(title, chartCreator);
        this.initView();
    }

    private void initView() {
        this.ctrPanel = this.getExtraComponent();
        this.toolBar = new JToolBar();
        this.toolBar.setLayout(new GridBagLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setBackground(UIConstants.INTEL_WHITE);
        this.ctrPanel.add(this.toolBar);
    }

    public void setTypes(DataType ... types) {
        if (types != null && types.length > 0) {
            this.dataTypeList = new ExJXList<DataType>(types);
            this.dataTypeList.setDisabledColor(UIConstants.INTEL_LIGHT_GRAY);
            this.dataType = types[0];
            this.prevDataType = types[0];
            this.setDataTypeListener(this.groupInfoTypeListener);
            this.addDataTypeButton();
        }
    }

    public void setDisbaledDataTypes(DataType ... types) {
        if (this.dataTypeList != null) {
            this.dataTypeList.setDisabledItem((DataType[])types);
        }
    }

    public void setDataTypeListener(final IDataTypeListener<DataType> listener) {
        this.groupInfoTypeListener = listener;
        if (this.dataTypeList != null && listener != null) {
            if (this.groupInfoTypeListSelectionListener != null) {
                this.dataTypeList.removeMouseListener(this.groupInfoTypeListSelectionListener);
            }
            this.groupInfoTypeListSelectionListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                        DataType type = (DataType)((Object)OptionChartsView.this.dataTypeList.getSelectedValue());
                        if (OptionChartsView.this.prevDataType != type) {
                            DataType oldType = OptionChartsView.this.prevDataType;
                            OptionChartsView.this.prevDataType = type;
                            if (OptionChartsView.this.dataTypeBtn != null) {
                                OptionChartsView.this.dataTypeBtn.setText(OptionChartsView.this.dataTypeList.getSelectedValue().toString());
                            }
                            listener.onDataTypeChange(oldType, type);
                        }
                        if (OptionChartsView.this.dataPopupOptions != null && OptionChartsView.this.dataPopupOptions.isVisible()) {
                            OptionChartsView.this.dataPopupOptions.hide();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
            this.dataTypeList.addMouseListener(this.groupInfoTypeListSelectionListener);
            this.setType(this.dataType);
        }
    }

    public void setType(DataType type) {
        this.dataTypeList.setSelectedValue((Object)type, true);
        this.prevDataType = type;
        if (this.dataTypeBtn != null) {
            this.dataTypeBtn.setText(this.dataTypeList.getSelectedValue().toString());
        }
    }

    protected void addDataTypeButton() {
        this.dataTypeBtn = new JButton(this.dataType.getName(), UIImages.DATA_TYPE.getImageIcon());
        this.dataTypeBtn.setFocusable(false);
        this.dataTypeBtn.setToolTipText(STLConstants.K0747_DATA_TYPE.getValue());
        this.dataTypeBtn.setBackground(UIConstants.INTEL_WHITE);
        ActionListener usrOptionsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!OptionChartsView.this.dataPopupOptions.isVisible()) {
                    OptionChartsView.this.dataPopupOptions.show();
                } else {
                    OptionChartsView.this.dataPopupOptions.hide();
                }
            }
        };
        this.dataTypeBtn.addActionListener(usrOptionsListener);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.gridx = 0;
        gc.weightx = 1.0;
        this.toolBar.add((Component)this.dataTypeBtn, gc);
        this.dataTypeList.setLayout(new GridBagLayout());
        this.dataTypeList.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.dataPopupOptions = new ButtonPopup(this.dataTypeBtn, (JComponent)((Object)this.dataTypeList)){

            @Override
            public void onShow() {
            }

            @Override
            public void onHide() {
            }
        };
    }

    public void setHistoryTypes(HistoryType ... types) {
        if (types != null && types.length > 0) {
            this.historyTypeList = new ExJXList<HistoryType>(types);
            this.historyTypeList.setDisabledColor(UIConstants.INTEL_LIGHT_GRAY);
            this.historyType = types[0];
            this.prevHistoryType = types[0];
            this.setHistoryTypeListener(this.historyTypeListener);
            this.addHistoryTypeButton();
        }
    }

    public void setDisabledHistoryTypes(HistoryType ... types) {
        if (this.historyTypeList != null) {
            this.historyTypeList.setDisabledItem((HistoryType[])types);
        }
    }

    public void setHistoryTypeListener(final IDataTypeListener<HistoryType> listener) {
        this.historyTypeListener = listener;
        if (this.historyTypeList != null && listener != null) {
            if (this.historyTypeListSelectionListener != null) {
                this.historyTypeList.removeMouseListener(this.historyTypeListSelectionListener);
            }
            this.historyTypeListSelectionListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                        HistoryType type = (HistoryType)((Object)OptionChartsView.this.historyTypeList.getSelectedValue());
                        if (OptionChartsView.this.prevHistoryType != type) {
                            HistoryType oldType = OptionChartsView.this.prevHistoryType;
                            OptionChartsView.this.prevHistoryType = type;
                            if (OptionChartsView.this.historyTypeBtn != null) {
                                OptionChartsView.this.historyTypeBtn.setText(OptionChartsView.this.historyTypeList.getSelectedValue().toString());
                            }
                            listener.onDataTypeChange(oldType, type);
                        }
                        if (OptionChartsView.this.historyPopupOptions != null && OptionChartsView.this.historyPopupOptions.isVisible()) {
                            OptionChartsView.this.historyPopupOptions.hide();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
            this.historyTypeList.addMouseListener(this.historyTypeListSelectionListener);
            this.setHistoryType(this.historyType);
        }
    }

    public void setHistoryType(HistoryType type) {
        this.historyTypeList.setSelectedValue((Object)type, true);
        if (this.historyTypeBtn != null) {
            this.historyTypeBtn.setText(this.historyTypeList.getSelectedValue().toString());
        }
    }

    protected void addHistoryTypeButton() {
        this.historyTypeBtn = new JButton(this.historyType.getName(), UIImages.HISTORY_ICON.getImageIcon());
        this.historyTypeBtn.setFocusable(false);
        this.historyTypeBtn.setToolTipText(STLConstants.K1113_HISTORY_SCOPE.getValue());
        this.historyTypeBtn.setBackground(UIConstants.INTEL_WHITE);
        ActionListener usrOptionsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!OptionChartsView.this.historyPopupOptions.isVisible()) {
                    OptionChartsView.this.historyPopupOptions.show();
                } else {
                    OptionChartsView.this.historyPopupOptions.hide();
                }
            }
        };
        this.historyTypeBtn.addActionListener(usrOptionsListener);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.toolBar.add((Component)this.historyTypeBtn, gc);
        this.historyTypeList.setLayout(new GridBagLayout());
        this.historyTypeList.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.historyPopupOptions = new ButtonPopup(this.historyTypeBtn, (JComponent)((Object)this.historyTypeList)){

            @Override
            public void onShow() {
            }

            @Override
            public void onHide() {
            }
        };
    }
}

