/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.api.IAssistant;
import com.intel.stl.ui.common.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public abstract class OptionDialog
extends JDialog
implements IAssistant {
    private static final long serialVersionUID = 4480551678945585493L;
    private final Object waitObj;
    protected JProgressBar progressBar;
    protected JPanel ctrPanel;
    private JButton okButton;
    private JButton cancelButton;
    protected int option;

    public OptionDialog(Component owner, String title, int optionType) {
        super(SwingUtilities.getWindowAncestor(owner), title);
        this.initComponent(optionType);
        this.waitObj = new Object();
    }

    protected void initComponent(int optionType) {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        JComponent mainPanel = this.getMainComponent();
        panel.add((Component)mainPanel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(true);
        panel.add((Component)this.progressBar, "South");
        this.getContentPane().add((Component)panel, "Center");
        this.ctrPanel = new JPanel();
        this.installButtons(this.ctrPanel, optionType);
        this.getContentPane().add((Component)this.ctrPanel, "South");
        this.setSize();
        this.setLocationRelativeTo(this.getOwner());
    }

    protected void setSize() {
        this.pack();
    }

    protected void installButtons(JPanel ctrPanel, int optionType) {
        ctrPanel.setLayout(new FlowLayout(4));
        if (optionType == 0 || optionType == 2) {
            this.okButton = new JButton("Ok");
            this.okButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionDialog.this.onOk();
                    OptionDialog.this.option = 0;
                    Object object = OptionDialog.this.waitObj;
                    synchronized (object) {
                        OptionDialog.this.waitObj.notify();
                    }
                }
            });
            ctrPanel.add(this.okButton);
        }
        if (optionType == 2) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionDialog.this.onCancel();
                    OptionDialog.this.option = 2;
                    Object object = OptionDialog.this.waitObj;
                    synchronized (object) {
                        OptionDialog.this.waitObj.notify();
                    }
                }
            });
            ctrPanel.add(this.cancelButton);
        }
    }

    public void onCancel() {
    }

    public void onOk() {
    }

    public void enableOk(boolean b) {
        this.okButton.setEnabled(b);
    }

    public void enableCancel(boolean b) {
        this.cancelButton.setEnabled(b);
    }

    protected abstract JComponent getMainComponent();

    public void showDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionDialog.this.setVisible(true);
            }
        });
    }

    @Override
    public int getOption(Throwable error) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Can not call from EDT!");
        }
        this.option = -1;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionDialog.this.progressBar.setString(null);
                OptionDialog.this.setVisible(true);
            }
        });
        this.waitForInput();
        return this.option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForInput() {
        Object object = this.waitObj;
        synchronized (object) {
            while (this.option == -1) {
                try {
                    this.waitObj.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void startProgress() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                OptionDialog.this.progressBar.setVisible(true);
                OptionDialog.this.progressBar.setIndeterminate(true);
                OptionDialog.this.repaint();
            }
        });
    }

    @Override
    public void stopProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionDialog.this.progressBar.setIndeterminate(false);
                OptionDialog.this.progressBar.setValue(100);
            }
        });
    }

    @Override
    public void reportProgress(final String note) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionDialog.this.progressBar.setString(note);
            }
        });
    }

    @Override
    public void close() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionDialog.this.onClose();
                OptionDialog.this.setVisible(false);
            }
        });
    }

    protected abstract void onClose();
}

