/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ExFormattedTextField;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.NumberFormatter;

public class SafeNumberField<N extends Number>
extends ExFormattedTextField {
    private static final long serialVersionUID = -9002349798796295869L;

    public SafeNumberField(NumberFormat format, N min, boolean inclusiveMin) {
        this(format, min, inclusiveMin, null, false);
    }

    public SafeNumberField(NumberFormat format, N min, boolean inclusiveMin, N max, boolean inclusiveMax) {
        super(new SafeNumberFormatter<N>(format, min, inclusiveMin, max, inclusiveMax));
        ((SafeNumberFormatter)this.getFormatter()).setParent(this);
    }

    public void setValidChars(String validChars) {
        ((SafeNumberFormatter)this.getFormatter()).setValidCharacters(validChars);
    }

    public static class SafeNumberFormatter<N extends Number>
    extends NumberFormatter {
        private static final long serialVersionUID = 6505406066904797986L;
        private String validCharacters = "0123456789+-.,%";
        private ExFormattedTextField parent;
        private final N min;
        private boolean inclusiveMin;
        private final N max;
        private boolean inclusiveMax;

        public SafeNumberFormatter(NumberFormat format, N min, boolean inclusiveMin) {
            this(format, min, inclusiveMin, null, false);
        }

        public SafeNumberFormatter(NumberFormat format, N min, boolean inclusiveMin, N max, boolean inclusiveMax) {
            super(format);
            this.min = min;
            this.inclusiveMin = inclusiveMin;
            this.max = max;
            this.inclusiveMax = inclusiveMax;
            this.setValueClass(min.getClass());
        }

        public String getValidCharacters() {
            return this.validCharacters;
        }

        public void setValidCharacters(String validCharacters) {
            this.validCharacters = validCharacters;
        }

        public void setParent(ExFormattedTextField parent) {
            this.parent = parent;
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            this.checkValidChar(text);
            Format format = this.getFormat();
            this.setValidationTooltip(this.createOutOfRangeTooltip(this.min, this.inclusiveMin, this.max, this.inclusiveMax, format));
            try {
                Object obj = format.parseObject(text);
                if (obj instanceof Number) {
                    Number num = (Number)obj;
                    if (this.inclusiveMin ? num.doubleValue() < ((Number)this.min).doubleValue() : num.doubleValue() <= ((Number)this.min).doubleValue()) {
                        throw new ParseException("Value not within min/max range", 0);
                    }
                    if (this.max != null && (this.inclusiveMax ? num.doubleValue() > ((Number)this.max).doubleValue() : num.doubleValue() >= ((Number)this.max).doubleValue())) {
                        throw new ParseException("Value not within min/max range", 0);
                    }
                }
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage(), 0);
            }
            Object res = super.stringToValue(text);
            return res;
        }

        protected void checkValidChar(String value) throws ParseException {
            for (int i = 0; i < value.length(); ++i) {
                if (this.isValidCharacter(value.charAt(i))) continue;
                this.setValidationTooltip(this.createInvalidCharTooltip(value.charAt(i)));
                throw new ParseException("Invalid char '" + value.charAt(i) + "'", 0);
            }
        }

        protected boolean isValidCharacter(char aChar) {
            String filter = this.getValidCharacters();
            return filter == null || filter.indexOf(aChar) != -1;
        }

        protected String createInvalidCharTooltip(char target) {
            return UILabels.STL50096_TEXT_FIELD_INVALID_CHAR.getDescription(Character.valueOf(target));
        }

        protected String createOutOfRangeTooltip(N min, boolean inclusiveMin, N max, boolean inclusiveMax, Format format) {
            String maxStr;
            String string = maxStr = max == null ? STLConstants.K0133_INFINITE.getValue() : format.format(max);
            if (max == null && ((Number)min).intValue() == 0 && !inclusiveMin) {
                return UILabels.STL81020_POSITIVE_VALIDATION.getDescription();
            }
            if (inclusiveMin) {
                if (inclusiveMax) {
                    return UILabels.STL81021_RANGE1_VALIDATION.getDescription(format.format(min), maxStr);
                }
                return UILabels.STL81022_RANGE2_VALIDATION.getDescription(format.format(min), maxStr);
            }
            if (inclusiveMax) {
                return UILabels.STL81023_RANGE3_VALIDATION.getDescription(format.format(min), maxStr);
            }
            return UILabels.STL81024_RANGE4_VALIDATION.getDescription(format.format(min), maxStr);
        }

        protected void setValidationTooltip(String tooltip) {
            if (this.parent != null) {
                this.parent.setValidationTooltip(tooltip);
            }
        }
    }
}

