/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.CableInfoBean;
import com.intel.stl.api.subnet.CableRecordBean;
import com.intel.stl.api.subnet.CableType;
import com.intel.stl.api.subnet.CertifiedRateType;
import com.intel.stl.api.subnet.DDCableInfoBean;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.PowerClassType;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.CableTypeViz;
import com.intel.stl.ui.model.CertifiedRateTypeViz;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.PortTypeViz;
import com.intel.stl.ui.model.PowerClassTypeViz;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;

public class CableInfoProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        FVResourceNode node = context.getResourceNode();
        PortRecordBean portBean = context.getPort();
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        if (portBean == null || portBean.getPortNum() == 0 && node.getParent().getType() == TreeNodeType.SWITCH) {
            this.getCableInfo(category, null);
            return;
        }
        CableRecordBean cableRecordBean = subnetApi.getCable(portBean.getEndPortLID(), portBean.getPortNum());
        if (cableRecordBean == null || cableRecordBean.getPortType() != PortTypeViz.STANDARD.getPortType().getValue()) {
            this.getCableInfo(category, null);
            return;
        }
        if (cableRecordBean.getDdCableInfo() != null) {
            this.getDDCableInfo(category, cableRecordBean.getDdCableInfo());
        } else {
            this.getCableInfo(category, cableRecordBean.getCableInfo());
        }
    }

    public void getCableInfo(DevicePropertyCategory category, CableInfoBean bean) {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        if (bean != null) {
            byte id = bean.getId();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_ID, CableInfoProcessor.hex(id));
            PowerClassType powerClass = bean.getPowerClass();
            if (powerClass != null) {
                try {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, PowerClassTypeViz.getPowerClassTypeVizFor(powerClass).getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, na);
            }
            boolean txCDRSupported = bean.getTxCDRSupported();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_SUP, txCDRSupported ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue());
            boolean rxCDRSupported = bean.getTxCDRSupported();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_SUP, rxCDRSupported ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue());
            byte connector = bean.getConnector();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CONNECTOR, CableInfoProcessor.hex(connector));
            byte bitRateLow = bean.getBitRateLow();
            byte bitRateHigh = bean.getBitRateHigh();
            Integer nominalBr = bean.stlCableInfoBitRate(bitRateLow, bitRateHigh);
            if (nominalBr != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_NOMINAL_BR, nominalBr.toString() + " " + STLConstants.K1152_CABLE_GB.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_NOMINAL_BR, na);
            }
            int om2Length = bean.getOm2Length();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM2_LEN, Integer.toString(om2Length) + " " + STLConstants.K1154_CABLE_M.getValue());
            int om3Length = bean.getOm3Length();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM3_LEN, Integer.toString(om3Length) + " " + STLConstants.K1154_CABLE_M.getValue());
            int om4Length = bean.getOm4Length();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_COPPER_LEN, Integer.toString(om4Length) + " " + STLConstants.K1154_CABLE_M.getValue());
            byte xmitTech = bean.getXmitTech();
            byte codeConnector = bean.getConnector();
            try {
                CableTypeViz cableType = CableTypeViz.getCableTypeVizFor(CableType.getCableType(xmitTech, codeConnector));
                if (cableType != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, cableType.getName());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
            }
            String vendorName = bean.getVendorName();
            if (vendorName != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, vendorName);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, na);
            }
            byte[] vendorOui = bean.getVendorOui();
            if (vendorOui != null) {
                StringBuilder sb = new StringBuilder(vendorOui.length * 2);
                sb.append("0x");
                for (byte b : vendorOui) {
                    sb.append(String.format("%02x", b));
                }
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, sb.toString());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, na);
            }
            String vendorPN = bean.getVendorPn();
            if (vendorPN != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, vendorPN);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, na);
            }
            String vendorRev = bean.getVendorRev();
            if (vendorRev != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, vendorRev);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, na);
            }
            int maxCaseTemp = bean.getMaxCaseTemp();
            if (maxCaseTemp > 0) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, Integer.toString(maxCaseTemp) + " " + STLConstants.K1158_CABLE_C.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, STLConstants.K1159_NOT_INDICATED.getValue());
            }
            byte ccBase = bean.getCcBase();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_BASE, CableInfoProcessor.hex(ccBase));
            boolean txInpEqAutoAdp = bean.getTxInpEqAutoAdp();
            if (txInpEqAutoAdp) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, STLConstants.K0386_FALSE.getValue());
            }
            boolean txInpEqFixProg = bean.getTxInpEqFixProg();
            if (txInpEqFixProg) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, STLConstants.K0386_FALSE.getValue());
            }
            boolean rxOutpEmphFixProg = bean.getRxOutpEmphFixProg();
            if (rxOutpEmphFixProg) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, STLConstants.K0386_FALSE.getValue());
            }
            boolean rxOutpAmplFixProg = bean.getRxOutpAmplFixProg();
            if (rxOutpAmplFixProg) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, STLConstants.K0386_FALSE.getValue());
            }
            boolean txCDROnOffCtrl = bean.getTxCDROnOffCtrl();
            if (txCDROnOffCtrl) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, STLConstants.K0386_FALSE.getValue());
            }
            boolean rxCDROnOffCtrl = bean.getRxCDROnOffCtrl();
            if (rxCDROnOffCtrl) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, STLConstants.K0386_FALSE.getValue());
            }
            boolean txSquelchImp = bean.isTxSquelchImp();
            if (txSquelchImp) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_SQUELCH_IMP, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_SQUELCH_IMP, STLConstants.K0386_FALSE.getValue());
            }
            boolean memPage02Provided = bean.isMemPage02Provided();
            if (memPage02Provided) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE02_PROV, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE02_PROV, STLConstants.K0386_FALSE.getValue());
            }
            boolean memPage01Provided = bean.isMemPage01Provided();
            if (memPage01Provided) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE01_PROV, STLConstants.K0385_TRUE.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE01_PROV, STLConstants.K0386_FALSE.getValue());
            }
            String vendorSn = bean.getVendorSN();
            if (vendorSn != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, vendorSn);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, na);
            }
            String dateCode = bean.getDateCode();
            if (dateCode != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, "20" + dateCode);
            } else {
                String beanDateCode = bean.getDateCode();
                dateCode = beanDateCode != null ? STLConstants.K1116_INVALID.getValue() : na;
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, dateCode);
            }
            byte ccExt = bean.getCcExt();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_EXT, CableInfoProcessor.hex(ccExt));
            boolean ccFlag = bean.getCertCableFlag();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_CABLE_FLAG, ccFlag ? STLConstants.K1155_CABLE_Y.getValue() : STLConstants.K1156_CABLE_N.getValue());
            int reachClass = bean.getReachClass();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_REACH_CLASS, Integer.toString(reachClass));
            CertifiedRateType certDataRate = bean.getCertDataRate();
            if (certDataRate != null) {
                try {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_DATA_RATE, CertifiedRateTypeViz.getCertifiedRateTypeVizFor(certDataRate).getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_DATA_RATE, na);
            }
        } else {
            this.getNullCableInfo(category);
        }
    }

    private void getNullCableInfo(DevicePropertyCategory category) {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_ID, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_SUP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_SUP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CONNECTOR, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_NOMINAL_BR, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM2_LEN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM3_LEN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_COPPER_LEN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_BASE, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_SQUELCH_IMP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE02_PROV, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE01_PROV, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_EXT, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_CABLE_FLAG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_REACH_CLASS, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_DATA_RATE, na);
    }

    public void getDDCableInfo(DevicePropertyCategory category, DDCableInfoBean bean) {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        if (bean != null) {
            byte id = bean.getId();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_ID, CableInfoProcessor.hex(id));
            String vendorName = bean.getVendorName();
            if (vendorName != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, vendorName);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, na);
            }
            byte[] vendorOui = bean.getVendorOui();
            if (vendorOui != null) {
                StringBuilder sb = new StringBuilder(vendorOui.length * 2);
                sb.append("0x");
                for (byte b : vendorOui) {
                    sb.append(String.format("%02x", b));
                }
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, sb.toString());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, na);
            }
            String vendorPN = bean.getVendorPn();
            if (vendorPN != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, vendorPN);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, na);
            }
            String vendorRev = bean.getVendorRev();
            if (vendorRev != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, vendorRev);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, na);
            }
            String vendorSn = bean.getVendorSN();
            if (vendorSn != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, vendorSn);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, na);
            }
            String dateCode = bean.getDateCode();
            if (dateCode != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, "20" + dateCode);
            } else {
                String beanDateCode = bean.getDateCode();
                dateCode = beanDateCode != null ? STLConstants.K1116_INVALID.getValue() : na;
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, dateCode);
            }
            double maxPwr = bean.getMaxPower();
            if (maxPwr > 0.0) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, String.format("%.2f %s", maxPwr, STLConstants.K1656_W_MAX.getValue()));
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, na);
            }
            byte xmitTech = bean.getXmitTech();
            byte codeConnector = bean.getConnector();
            try {
                CableTypeViz cableType = CableTypeViz.getCableTypeVizFor(CableType.getCableType(xmitTech, codeConnector));
                if (cableType != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, cableType.getName());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
            }
            short cableLength = bean.getCableLength();
            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_LENGTH, Short.toString(cableLength) + " " + STLConstants.K1154_CABLE_M.getValue());
        } else {
            this.getNullDDCableInfo(category);
        }
    }

    private void getNullDDCableInfo(DevicePropertyCategory category) {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_ID, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_LENGTH, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
    }
}

