/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.FlitControlBean;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class FlitControlInterleaveProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        boolean isHFI = context.isHFI();
        boolean isExternalSWPort = context.isExternalSWPort();
        if (portInfo == null) {
            this.getEmptyFlitControlInterleave(category);
            return;
        }
        FlitControlBean flitInfo = portInfo.getFlitControl();
        if (flitInfo == null) {
            this.getEmptyFlitControlInterleave(category);
            return;
        }
        if (isExternalSWPort || isHFI) {
            FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.DISTANCE_SUP, FlitControlInterleaveProcessor.dec(flitInfo.getDistanceSupported()));
            FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.DISTANCE_ENA, FlitControlInterleaveProcessor.dec(flitInfo.getDistanceEnabled()));
        } else {
            FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.DISTANCE_SUP, STLConstants.K0383_NA.getValue());
            FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.DISTANCE_ENA, STLConstants.K0383_NA.getValue());
        }
        FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.MAX_NEST_LVL_TX, FlitControlInterleaveProcessor.dec(flitInfo.getMaxNestLevelTxEnabled()));
        FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.MAX_NEST_LVL_RX, FlitControlInterleaveProcessor.dec(flitInfo.getMaxNestLevelRxSupported()));
    }

    private void getEmptyFlitControlInterleave(DevicePropertyCategory category) {
        FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.DISTANCE_SUP, "");
        FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.DISTANCE_ENA, "");
        FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.MAX_NEST_LVL_TX, "");
        FlitControlInterleaveProcessor.addProperty(category, DeviceProperty.MAX_NEST_LVL_RX, "");
    }
}

