/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.LinkSpeedMask;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.LinkSpeedMaskViz;
import java.util.List;

public class LinkSpeedProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo != null) {
            short val = portInfo.getLinkSpeedEnabled();
            LinkSpeedProcessor.addProperty(category, DeviceProperty.SPEEDS_ENABLED, this.getLinkSpeedString(val));
            val = portInfo.getLinkSpeedSupported();
            LinkSpeedProcessor.addProperty(category, DeviceProperty.SPEEDS_SUPPORTED, this.getLinkSpeedString(val));
            val = portInfo.getLinkSpeedActive();
            LinkSpeedProcessor.addProperty(category, DeviceProperty.SPEEDS_ACTIVE, this.getLinkSpeedString(val));
        } else {
            LinkSpeedProcessor.addProperty(category, DeviceProperty.SPEEDS_ENABLED, "");
            LinkSpeedProcessor.addProperty(category, DeviceProperty.SPEEDS_SUPPORTED, "");
            LinkSpeedProcessor.addProperty(category, DeviceProperty.SPEEDS_ACTIVE, "");
        }
    }

    private String getLinkSpeedString(short val) {
        StringBuilder lsStr = new StringBuilder();
        String join = "";
        String or = " " + STLConstants.K0388_OR.getValue() + " ";
        List<LinkSpeedMask> masks = LinkSpeedMask.getSpeedMasks(val);
        for (LinkSpeedMask mask : masks) {
            lsStr.append(join);
            lsStr.append(LinkSpeedMaskViz.getLinkSpeedMaskStr(mask));
            join = or;
        }
        return lsStr.toString();
    }
}

