/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.MFTRecordBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.List;

public class MFTTableProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        int lid;
        FVResourceNode node = context.getResourceNode();
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        List<MFTRecordBean> mftRecs = subnetApi.getMFT(lid = node.getId());
        if (mftRecs == null) {
            return;
        }
        for (MFTRecordBean mft : mftRecs) {
            lid = mft.getBlockNum() * 8 + 49152;
            long[] retMasks = mft.getMftTable();
            int i = 0;
            while (i < retMasks.length) {
                if (retMasks[i] > 0L) {
                    DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.MFT_TABLE, MFTTableProcessor.hex(lid), (Object)MFTTableProcessor.hex(retMasks[i]));
                    category.addPropertyItem(property);
                }
                ++i;
                ++lid;
            }
        }
    }
}

