/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class PortPartitionEnforcementProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        NodeInfoBean nodeInfo = context.getNodeInfo();
        PortInfoBean portInfo = context.getPortInfo();
        PortRecordBean portBean = context.getPort();
        if (nodeInfo == null || portInfo == null || portBean == null) {
            this.setPartitionEnforcement(category, "", "");
            return;
        }
        String trueStr = STLConstants.K0080_ON.getValue();
        String falseStr = STLConstants.K0699_OFF.getValue();
        String inboundValue = STLConstants.K0383_NA.getValue();
        String outboundValue = STLConstants.K0383_NA.getValue();
        if (nodeInfo.getNodeTypeEnum() == NodeType.SWITCH && portBean.getPortNum() > 0) {
            inboundValue = portInfo.isPartitionEnforcementInbound() ? trueStr : falseStr;
            outboundValue = portInfo.isPartitionEnforcementOutbound() ? trueStr : falseStr;
        }
        this.setPartitionEnforcement(category, inboundValue, outboundValue);
    }

    private void setPartitionEnforcement(DevicePropertyCategory category, String inbound, String outbound) {
        PortPartitionEnforcementProcessor.addProperty(category, DeviceProperty.PARTITION_ENFORCE_IN, inbound);
        PortPartitionEnforcementProcessor.addProperty(category, DeviceProperty.PARTITION_ENFORCE_OUT, outbound);
    }
}

