/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class PortSubnetProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        String falseStr;
        PortInfoBean portInfo = context.getPortInfo();
        boolean isHFI = context.isHFI();
        boolean isExternalSWPort = context.isExternalSWPort();
        if (portInfo == null) {
            this.getEmptyPortSubnet(category);
            return;
        }
        String trueStr = STLConstants.K0385_TRUE.getValue();
        String value = falseStr = STLConstants.K0386_FALSE.getValue();
        if (portInfo.isClientReregister()) {
            value = trueStr;
        }
        if (isExternalSWPort) {
            PortSubnetProcessor.addProperty(category, DeviceProperty.CLIENT_REREGISTER, STLConstants.K0383_NA.getValue());
            PortSubnetProcessor.addProperty(category, DeviceProperty.MULTICAST_PKEY_TRAP, STLConstants.K0383_NA.getValue());
        } else {
            PortSubnetProcessor.addProperty(category, DeviceProperty.CLIENT_REREGISTER, value);
            PortSubnetProcessor.addProperty(category, DeviceProperty.MULTICAST_PKEY_TRAP, PortSubnetProcessor.dec(portInfo.getMulPKeyTrapSuppressionEnabled()));
        }
        PortSubnetProcessor.addProperty(category, DeviceProperty.MULTICAST_MASK, PortSubnetProcessor.hex(portInfo.getMulticastMask()));
        if (!isHFI) {
            PortSubnetProcessor.addProperty(category, DeviceProperty.COLLECTIVE_MASK, STLConstants.K0383_NA.getValue());
        } else {
            PortSubnetProcessor.addProperty(category, DeviceProperty.COLLECTIVE_MASK, PortSubnetProcessor.hex(portInfo.getCollectiveMask()));
        }
    }

    private void getEmptyPortSubnet(DevicePropertyCategory category) {
        PortSubnetProcessor.addProperty(category, DeviceProperty.CLIENT_REREGISTER, "");
        PortSubnetProcessor.addProperty(category, DeviceProperty.MULTICAST_PKEY_TRAP, "");
        PortSubnetProcessor.addProperty(category, DeviceProperty.MULTICAST_MASK, "");
        PortSubnetProcessor.addProperty(category, DeviceProperty.COLLECTIVE_MASK, "");
    }
}

