/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.configuration.view.IPropertyRenderer;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.model.IPropertyCategory;
import com.intel.stl.ui.model.PropertyItem;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class DefaultPropertyRenderer
implements IPropertyRenderer {
    private static final String NA = STLConstants.K0039_NOT_AVAILABLE.getValue();

    @Override
    public Component getKeyHeaderComponent(IPropertyCategory<?> category, int row, PropertyVizStyle style) {
        String key = category.getKeyHeader();
        JLabel res = ComponentFactory.getH4Label(key == null ? "" : key, 1);
        style.decorateHeaderKey(res, row);
        return res;
    }

    @Override
    public Component getValueHeaderComponent(IPropertyCategory<?> category, int row, PropertyVizStyle style) {
        String value = category.getValueHeader();
        JLabel res = ComponentFactory.getH4Label(value == null ? "" : value, 1);
        style.decorateHeaderKey(res, row);
        return res;
    }

    @Override
    public Component getKeyComponent(PropertyItem<?> item, int itemIndex, int row, PropertyVizStyle style) {
        String key = item.getLabel();
        JLabel res = ComponentFactory.getH4Label(key == null ? "" : key, 0);
        res.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 3));
        style.decorateKey(res, itemIndex);
        return res;
    }

    @Override
    public Component getValueComponent(PropertyItem<?> item, int itemIndex, int row, PropertyVizStyle style) {
        String value = item.getValue();
        JLabel res = ComponentFactory.getH4Label(value == null ? NA : value, 0);
        res = ComponentFactory.deriveLabel(res, false, 250);
        res.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 2));
        style.decorateValue(res, itemIndex);
        return res;
    }
}

