/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.configuration.view.DevicePropertyCategoryPanel;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import java.awt.Component;
import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class LFTHistogramPanel
extends DevicePropertyCategoryPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension PREFERRED_CHART_SIZE = new Dimension(360, 240);
    private HistogramDataset dataset;
    private ChartPanel chartPanel;

    @Override
    public void modelUpdateFailed(DevicePropertyCategory model, Throwable caught) {
    }

    @Override
    public void modelChanged(DevicePropertyCategory model) {
        double[] values = (double[])model.getProperty(DeviceProperty.LFT_SERIES).getObject();
        int numPorts = (Integer)model.getProperty(DeviceProperty.NUM_PORTS).getObject();
        this.dataset.addSeries((Comparable)((Object)"Port"), values, ++numPorts, 0.0, (double)numPorts);
        this.chartPanel.getChart().getXYPlot().getDomainAxis().setRange(0.0, (double)numPorts);
    }

    @Override
    public void initComponents() {
        this.dataset = new HistogramDataset();
        JFreeChart chart = ComponentFactory.createHistogramChart(STLConstants.K0427_PORT_NUMBER.getValue(), STLConstants.K0390_NUM_LIDS.getValue(), (IntervalXYDataset)this.dataset);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainPannable(true);
        plot.setRangePannable(true);
        final String portLabel = "<html>" + STLConstants.K0427_PORT_NUMBER.getValue() + ": ";
        final String lidCountLabel = "<br>" + STLConstants.K0390_NUM_LIDS.getValue() + ": ";
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesToolTipGenerator(0, new XYToolTipGenerator(){

            public String generateToolTip(XYDataset dataset, int arg1, int arg2) {
                int portNum = (int)dataset.getXValue(arg1, arg2);
                int lidCount = (int)dataset.getYValue(arg1, arg2);
                return portLabel + portNum + lidCountLabel + lidCount + "</html>";
            }
        });
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setMouseWheelEnabled(true);
        this.chartPanel.setPreferredSize(PREFERRED_CHART_SIZE);
        this.propsPanel.add((Component)this.chartPanel);
    }
}

