/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.configuration.view.DefaultPropertyRenderer;
import com.intel.stl.ui.configuration.view.IPropertyRenderer;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.model.IPropertyCategory;
import com.intel.stl.ui.model.PropertyItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;

public class PropertyCategoryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected PropertyVizStyle style;
    protected IPropertyRenderer propertyRenderer;

    public PropertyCategoryPanel() {
        this(new PropertyVizStyle());
    }

    public PropertyCategoryPanel(PropertyVizStyle style) {
        this.style = style;
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setBackground(UIConstants.INTEL_WHITE);
    }

    public IPropertyRenderer getPropertyRenderer() {
        if (this.propertyRenderer == null) {
            this.propertyRenderer = new DefaultPropertyRenderer();
        }
        return this.propertyRenderer;
    }

    public void setPropertyRenderer(IPropertyRenderer propertyRenderer) {
        this.propertyRenderer = propertyRenderer;
    }

    public PropertyVizStyle getStyle() {
        return this.style;
    }

    public void setStyle(PropertyVizStyle style) {
        this.style = style;
    }

    public <C extends IPropertyCategory<? extends PropertyItem<?>>> void setModel(C model) {
        int row = 0;
        this.removeAll();
        if (model.getKeyHeader() != null || model.getValueHeader() != null) {
            this.addHeaders(model, row);
            ++row;
        }
        int itemIndex = 0;
        for (PropertyItem<?> item : model.getItems()) {
            this.addPropertyItem(item, row, itemIndex++);
            ++row;
        }
        this.repaint();
    }

    private void addHeaders(IPropertyCategory<?> category, int row) {
        GridBagConstraints gc = this.createConstraints(2, 2, 0, 3);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        Component keyComp = this.getPropertyRenderer().getKeyHeaderComponent(category, row, this.style);
        keyComp.setName((Object)((Object)WidgetName.PM_PROP_HEADER_NAME_) + category.getKeyHeader());
        String valueHeader = category.getValueHeader();
        if (valueHeader != null && valueHeader.length() > 0) {
            this.add(keyComp, gc);
            gc = this.createConstraints(2, 2, 0, 3);
            gc.gridx = 1;
            gc.gridy = 0;
            Component valComp = this.getPropertyRenderer().getValueHeaderComponent(category, row, this.style);
            valComp.setName((Object)((Object)WidgetName.PM_PROP_HEADER_VALUE_) + category.getKeyHeader());
            this.add(valComp, gc);
        } else {
            gc.gridwidth = 2;
            this.add(keyComp, gc);
        }
        gc.fill = 1;
        gc.anchor = 18;
        gc.gridwidth = 0;
        this.add(Box.createGlue(), gc);
    }

    private void addPropertyItem(PropertyItem<?> item, int row, int itemIndex) {
        GridBagConstraints gc = this.createConstraints(0, 12, 0, 0);
        gc.gridx = 0;
        gc.gridy = row;
        Component keyComp = this.getPropertyRenderer().getKeyComponent(item, itemIndex, row, this.style);
        keyComp.setName((Object)((Object)WidgetName.PM_PROP_ITEM_NAME_) + item.getLabel());
        this.add(keyComp, gc);
        gc = this.createConstraints(0, 0, 0, 3);
        gc.gridx = 1;
        gc.gridy = row;
        Component valComp = this.getPropertyRenderer().getValueComponent(item, itemIndex, row, this.style);
        valComp.setName((Object)((Object)WidgetName.PM_PROP_ITEM_VALUE_) + item.getLabel());
        this.add(valComp, gc);
        gc.fill = 1;
        gc.anchor = 18;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        this.add(Box.createGlue(), gc);
    }

    private GridBagConstraints createConstraints(int yPadTop, int xPadLeft, int yPadBtm, int xPadRight) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 21;
        gc.fill = 1;
        gc.insets = new Insets(yPadTop, xPadLeft, yPadBtm, xPadRight);
        gc.weightx = 1.0;
        return gc;
    }
}

