/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.console.ConsoleTerminalController;
import com.intel.stl.ui.console.IConsoleEventListener;
import com.intel.stl.ui.console.IConsoleLogin;
import com.intel.stl.ui.console.ITabListener;
import com.intel.stl.ui.console.ITty;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.console.view.ConsoleSubpageView;
import com.intel.stl.ui.console.view.ConsoleTerminalView;
import com.intel.stl.ui.console.view.ConsoleView;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.view.IFabricView;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConsoleDispatchManager
implements IConsoleEventListener {
    public static final int MAX_NUM_CONSOLES = 50;
    public static final int MAX_NUM_CONSOLES_IN_SESSION = 10;
    public static final int SSH_PORT = 22;
    public static final int REASON_INIT = 1;
    public static final int REASON_UNLOCK = 2;
    private final ConsoleSubpageView subpageView;
    private Context context;
    private IProgressObserver observer;
    private LoginBean defaultLoginBean;
    private ConsoleTerminalController console;
    private ConsoleTerminalView consoleTerminalView;
    private IConsoleLogin consoleLogin;
    private final IConsoleEventListener listener = this;
    private ITabListener tabListener;
    private Thread initConsoleThread = null;
    private Thread unlockThread = null;
    private volatile ConcurrentHashMap<Integer, ConsoleTerminalController> consoleControllers = new ConcurrentHashMap();
    private final LinkedHashMap<Session, AtomicInteger> sessionMap = new LinkedHashMap();
    private int consoleNum = 0;
    private int consoleCounter = 0;
    private final IFabricView owner;

    public ConsoleDispatchManager(ConsoleView consoleView, IFabricView owner) {
        this.owner = owner;
        this.subpageView = consoleView.getConsoleSubpageView();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.context = context;
        this.observer = observer;
        SubnetDescription sd = context.getSubnetDescription();
        this.defaultLoginBean = new LoginBean(sd.getCurrentUser(), sd.getCurrentFE().getHost(), String.valueOf(22));
        this.subpageView.setDefaultLoginBean(this.defaultLoginBean);
    }

    @Override
    public ConsoleTerminalController getConsoleController(Integer index) {
        return this.consoleControllers.get(index);
    }

    @Override
    public void addNewConsole(final LoginBean loginBean, final boolean showDialog, final String command) {
        Runnable addConsole = new Runnable(){

            @Override
            public void run() {
                ConsoleDispatchManager.this.consoleNum++;
                if (ConsoleDispatchManager.this.consoleNum <= 50) {
                    ConsoleDispatchManager.this.consoleTerminalView = new ConsoleTerminalView(ConsoleDispatchManager.this.owner, ConsoleDispatchManager.this.subpageView);
                    ConsoleDispatchManager.this.consoleLogin = ConsoleDispatchManager.this.consoleTerminalView.getConsoleLogin();
                    ConsoleDispatchManager.this.consoleLogin.setConsoleEventListener(ConsoleDispatchManager.this.listener);
                    ConsoleDispatchManager.this.displayMaxConsoles(false);
                    ConsoleDispatchManager.this.console = new ConsoleTerminalController(ConsoleDispatchManager.this.consoleTerminalView, STLConstants.K2107_ADM_CONSOLE.getValue() + " " + ++ConsoleDispatchManager.this.consoleCounter + ", ", STLConstants.K2108_ADM_CONSOLE_DESC.getValue(), ConsoleDispatchManager.this.consoleNum, ConsoleDispatchManager.this.subpageView.getConsoleHelpListener());
                    ConsoleDispatchManager.this.console.setContext(ConsoleDispatchManager.this.context, ConsoleDispatchManager.this.observer);
                    ConsoleDispatchManager.this.console.setNewConsoleListener(ConsoleDispatchManager.this.listener);
                    ConsoleDispatchManager.this.subpageView.setTab(ConsoleDispatchManager.this.console);
                    boolean newConsolesAllowed = ConsoleDispatchManager.this.consoleNum <= 50;
                    ConsoleDispatchManager.this.tabListener = ConsoleDispatchManager.this.subpageView.getNewTabView();
                    ConsoleDispatchManager.this.tabListener.enableNewTab(newConsolesAllowed);
                    ConsoleDispatchManager.this.consoleTerminalView.enableNewTab(newConsolesAllowed);
                    if (showDialog) {
                        ConsoleDispatchManager.this.consoleLogin.showLogin(ConsoleDispatchManager.this.defaultLoginBean, true, ConsoleDispatchManager.this.consoleNum);
                    } else {
                        try {
                            ConsoleDispatchManager.this.initializeConsole(loginBean, command);
                        }
                        catch (NumberFormatException e) {
                            ConsoleDispatchManager.this.consoleLogin.showMessage(UILabels.STL80002_INVALID_PORT_NUMBER.getDescription(loginBean.getPortNum()));
                            ConsoleDispatchManager.this.consoleLogin.killProgress();
                        }
                    }
                } else {
                    ConsoleDispatchManager.this.consoleNum--;
                    ConsoleDispatchManager.this.displayMaxConsoles(true);
                }
            }
        };
        Util.runInEDT(addConsole);
    }

    @Override
    public void initializeConsole(LoginBean loginBean, String command) throws NumberFormatException {
        this.tabListener = this.subpageView.getNewTabView();
        this.tabListener.enableNewTab(false);
        this.consoleTerminalView.enableCommanding(false);
        if (command == null) {
            this.console.initializeTerminal(loginBean);
        } else {
            this.console.initializeTerminal(loginBean, command);
        }
    }

    @Override
    public void updatePersonalizedTab(LoginBean loginBean, String command) {
        this.subpageView.updatePersonalizedTab(loginBean.getUserName(), command);
    }

    @Override
    public void cleanup() {
        Iterator it = ((ConcurrentHashMap.KeySetView)this.consoleControllers.keySet()).iterator();
        while (it.hasNext()) {
            this.removeConsole(this.consoleControllers.get(it.next()).getId());
        }
    }

    @Override
    public void onConnect(boolean connected, String command) {
        if (connected) {
            String cmd;
            this.consoleLogin.hideLogin();
            this.consoleControllers.put(this.consoleNum, this.console);
            LoginBean loginBean = this.console.getLoginInfo();
            this.console.updateInfoPanel(loginBean);
            String string = cmd = command == null ? " " : command;
            if (loginBean != null) {
                this.console.setName(loginBean.getUserName() + "," + cmd);
                this.subpageView.updatePersonalizedTab(loginBean.getUserName(), cmd);
                Session session = loginBean.getSession();
                if (this.sessionMap.get(session) == null) {
                    this.sessionMap.put(session, new AtomicInteger(1));
                } else if (this.sessionMap.get(session) == null) {
                    this.sessionMap.put(session, new AtomicInteger(1));
                } else {
                    this.incrementSessionUsers(session);
                }
            }
        }
        this.consoleLogin.killProgress();
        this.tabListener.enableNewTab(true);
        this.consoleTerminalView.enableCommanding(true);
        try {
            ConsoleTerminalController.ConsoleInitializer consoleInitializer = new ConsoleTerminalController.ConsoleInitializer(this.console);
            consoleInitializer.initializeCommands(this.console.getLoginInfo());
        }
        catch (NumberFormatException consoleInitializer) {
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onConnectFail(ConsoleTerminalController console, int reason, Exception e) {
        if (e instanceof NumberFormatException) {
            this.consoleLogin.showMessage(UILabels.STL80002_INVALID_PORT_NUMBER.getDescription(this.defaultLoginBean.getPortNum()));
        } else if (e instanceof JSchException) {
            String msg = new String();
            msg = e.getMessage().compareTo("Auth fail") == 0 ? UILabels.STL80003_AUTHENTICATION_FAILURE.getDescription() : (e.getMessage().startsWith("SSH_MSG_DISCONNECT") ? e.getMessage() : UILabels.STL80001_CONSOLE_CONNECTION_ERROR.getDescription() + " " + this.consoleLogin.getHostName() + ": " + e.getMessage());
            this.consoleLogin.showMessage(msg);
        } else {
            this.consoleLogin.showMessage(StringUtils.getErrorMessage(e));
        }
        this.consoleLogin.killProgress();
        this.tabListener.enableNewTab(true);
        this.consoleTerminalView.enableCommanding(true);
        if (console != null && reason == 1) {
            console.shutDownConsole();
            this.closeChannel(console);
            this.closeSession(console);
        }
    }

    @Override
    public void setTabListener(ITabListener tabListener) {
        this.tabListener = tabListener;
    }

    @Override
    public synchronized void removeConsole(int id) {
        ConsoleTerminalController currentConsole;
        if (this.consoleControllers.size() > 0 && (currentConsole = this.consoleControllers.get(id)) != null) {
            Session currentSession = currentConsole.getSession();
            this.decrementSessionUsers(currentSession);
            this.displayMaxConsoles(false);
            currentConsole.shutDownConsole();
        }
        if (this.consoleNum > 0) {
            --this.consoleNum;
        }
    }

    protected void displayMaxConsoles(boolean enable) {
        Iterator it = ((ConcurrentHashMap.KeySetView)this.consoleControllers.keySet()).iterator();
        while (it.hasNext()) {
            ConsoleTerminalController console = this.consoleControllers.get(it.next());
            if (console == null) continue;
            ((ConsoleTerminalView)console.getView()).displayMaxConsoles(enable);
        }
    }

    protected void incrementSessionUsers(Session session) {
        AtomicInteger numUsers = this.sessionMap.get(session);
        if (numUsers != null) {
            numUsers.incrementAndGet();
        }
        this.sessionMap.put(session, numUsers);
    }

    protected void decrementSessionUsers(Session session) {
        if (this.sessionMap != null && session != null) {
            AtomicInteger numUsers = this.sessionMap.get(session);
            if (numUsers != null) {
                numUsers.decrementAndGet();
            }
            this.sessionMap.put(session, numUsers);
        }
    }

    @Override
    public int getNumConsoles(boolean connectedOnly) {
        if (connectedOnly) {
            return this.consoleControllers.size();
        }
        return this.consoleNum;
    }

    @Override
    public IConsoleLogin getConsoleLogin() {
        return this.consoleLogin;
    }

    @Override
    public void initializeConsoleThread(final int consoleId, final LoginBean loginBean, final String command) {
        this.initConsoleThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConsoleDispatchManager.this.initializeConsole(loginBean, command);
                }
                catch (Exception e) {
                    ConsoleDispatchManager.this.onConnectFail((ConsoleTerminalController)ConsoleDispatchManager.this.consoleControllers.get(consoleId), 1, e);
                }
            }
        });
        if (this.initConsoleThread != null && !this.initConsoleThread.isAlive()) {
            this.initConsoleThread.start();
        }
    }

    @Override
    public void onUnlockThread(final int consoleId, final char[] pw) {
        this.unlockThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConsoleTerminalController console = (ConsoleTerminalController)ConsoleDispatchManager.this.consoleControllers.get(consoleId);
                    if (console != null) {
                        console.onUnlock(pw);
                    }
                }
                catch (JSchException e) {
                    ConsoleDispatchManager.this.onConnectFail(ConsoleDispatchManager.this.console, 2, (Exception)((Object)e));
                }
            }
        });
        if (this.unlockThread != null && !this.unlockThread.isAlive()) {
            this.unlockThread.start();
        }
    }

    @Override
    public void closeSession(ConsoleTerminalController console) {
        ITty tty;
        Session session;
        AtomicInteger numUsers;
        if (console != null && (numUsers = this.sessionMap.get(session = console.getSession())) != null && numUsers.get() == 0 && (tty = console.getTty()) != null) {
            tty.close();
            System.out.println("Session closed!\n");
            this.sessionMap.remove(session);
        }
    }

    protected void closeChannel(ConsoleTerminalController console) {
        ITty tty = null;
        if (console != null && (tty = console.getTty()) != null) {
            tty.closeChannel();
        }
    }

    @Override
    public synchronized void terminalStopped(int consoleId) {
        ConsoleTerminalController console = this.consoleControllers.get(consoleId);
        if (console != null && !console.isConnected()) {
            this.closeChannel(console);
            Session session = console.getSession();
            AtomicInteger numUsers = this.sessionMap.get(session);
            if (numUsers != null && numUsers.get() == 0) {
                this.closeSession(console);
            }
            this.consoleControllers.remove(consoleId);
        }
    }

    @Override
    public boolean isConsoleAllowed(ConsoleTerminalController console) {
        AtomicInteger numUsers = this.sessionMap.get(console.getSession());
        int numUsersInt = 0;
        if (numUsers != null) {
            numUsersInt = numUsers.get();
        }
        return numUsersInt < 10;
    }
}

