/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.common.IHelp;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IntelTabbedPaneUI;
import com.intel.stl.ui.console.ConsoleTerminalController;
import com.intel.stl.ui.console.IConsoleEventListener;
import com.intel.stl.ui.console.IConsoleListener;
import com.intel.stl.ui.console.ITabListener;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.console.view.ConsoleTabView;
import com.intel.stl.ui.console.view.ConsoleTerminalView;
import com.intel.stl.ui.console.view.NewTabView;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConsoleSubpageView
extends JPanel
implements ITabListener {
    private static final long serialVersionUID = -5831289826804475532L;
    private JTabbedPane tabbedPane;
    private JButton helpBtn;
    private IntelTabbedPaneUI tabUI;
    private JPanel ctrPanel;
    private NewTabView newTabView;
    private LoginBean defaultLoginBean;
    private IConsoleEventListener consoleEventListener;
    private final IHelp consoleHelpListener;
    private final List<ConsoleTabView> tabList = new ArrayList<ConsoleTabView>();

    public ConsoleSubpageView(IHelp consoleHelpListener) {
        this.consoleHelpListener = consoleHelpListener;
        this.initComponents();
    }

    protected void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.tabUI = new IntelTabbedPaneUI();
        this.ctrPanel = this.tabUI.getControlPanel();
        this.ctrPanel.setLayout(new BorderLayout());
        this.ctrPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 5));
        this.tabbedPane.setUI(this.tabUI);
        this.tabUI.setFont(UIConstants.H4_FONT);
        this.tabUI.setTabAreaInsets(new Insets(2, 5, 4, 5));
        this.addNewTab("+");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Runnable highlightTabs = new Runnable(){

                    @Override
                    public void run() {
                        if (ConsoleSubpageView.this.tabbedPane.getSelectedIndex() >= 0) {
                            String command;
                            ConsoleSubpageView.this.highlightTabs();
                            Integer tabbedPaneIndex = ConsoleSubpageView.this.tabbedPane.getSelectedIndex();
                            ConsoleTerminalController consoleController = ConsoleSubpageView.this.consoleEventListener.getConsoleController(tabbedPaneIndex + 1);
                            if (consoleController != null && (command = consoleController.getLastCommand()) != null) {
                                ConsoleSubpageView.this.consoleHelpListener.parseCommand(command);
                                ConsoleSubpageView.this.consoleHelpListener.updateSelection(command);
                            }
                        }
                    }
                };
                Util.runInEDT(highlightTabs);
            }
        });
        this.helpBtn = ComponentFactory.getImageButton(UIImages.HELP_ICON.getImageIcon());
        this.helpBtn.setToolTipText(STLConstants.K0037_HELP.getValue());
        this.ctrPanel.add(this.helpBtn);
    }

    public void enableHelp(boolean b) {
        if (this.helpBtn != null) {
            this.helpBtn.setEnabled(b);
        }
    }

    public JButton getHelpButton() {
        return this.helpBtn;
    }

    public void setDefaultLoginBean(LoginBean defaultLoginBean) {
        this.defaultLoginBean = defaultLoginBean;
    }

    public void setConsoleListener(IConsoleEventListener consoleEventListener) {
        this.consoleEventListener = consoleEventListener;
    }

    public JComponent getMainComponent() {
        return this.tabbedPane;
    }

    public String getCurrentSubpage() {
        int currentTab = this.tabbedPane.getSelectedIndex();
        if (currentTab < 0) {
            return null;
        }
        return this.tabbedPane.getTitleAt(currentTab);
    }

    protected void addNewTab(String symbol) {
        this.newTabView = new NewTabView(this.defaultLoginBean, this.consoleEventListener);
        this.tabbedPane.addTab(symbol, new JLabel());
        this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfTab(symbol), this.newTabView);
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfTab(symbol), false);
        this.consoleHelpListener.resetView();
    }

    public synchronized void setTab(IConsoleListener subpage) {
        this.tabbedPane.remove(this.tabbedPane.getTabCount() - 1);
        this.tabbedPane.addTab(subpage.getName(), subpage.getIcon(), subpage.getView(), subpage.getDescription());
        ((ConsoleTerminalView)subpage.getView()).setFocus();
        this.addNewTab("+");
        this.createPersonalizeTab(subpage);
        if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 2);
        }
        this.highlightTabs();
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public void createPersonalizeTab(IConsoleListener subpage) {
        int tabIndex = this.tabbedPane.getTabCount() - 2;
        String title = subpage.getName();
        String[] tabNames = title.split(",");
        ConsoleTabView consoleTabView = new ConsoleTabView(tabIndex, tabNames, subpage.getId());
        consoleTabView.addConsoleListener(subpage);
        this.tabList.add(consoleTabView);
        consoleTabView.addTabListener(this);
        boolean highlight = false;
        String currentSubpage = this.getCurrentSubpage();
        if (currentSubpage != null) {
            highlight = currentSubpage.equals(title);
        }
        consoleTabView.setLabelProperties(highlight);
        this.tabbedPane.setTabComponentAt(consoleTabView.getTabIndex(), consoleTabView.getMainComponent());
        this.highlightTabs();
    }

    public void updatePersonalizedTab(String userName, String command) {
        ConsoleTabView ctv = (ConsoleTabView)this.tabbedPane.getTabComponentAt(this.tabbedPane.getSelectedIndex());
        if (ctv != null) {
            ctv.setUserName(userName);
            ctv.setCommandName(command);
        }
        this.highlightTabs();
    }

    public void highlightTabs() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            ConsoleTabView tabView;
            boolean highlight;
            boolean bl = highlight = i == this.tabbedPane.getSelectedIndex();
            if (this.tabbedPane.getTabComponentAt(i) instanceof NewTabView || (tabView = (ConsoleTabView)this.tabbedPane.getTabComponentAt(i)) == null) continue;
            tabView.setLabelProperties(highlight);
        }
    }

    @Override
    public synchronized void closeConsole(ConsoleTabView tabView) {
        this.consoleEventListener.removeConsole(tabView.getConsoleId());
        int deletedKey = tabView.getTabIndex();
        this.tabbedPane.remove(tabView.getTabIndex());
        this.tabList.remove(deletedKey);
        if (deletedKey == this.tabList.size()) {
            this.tabbedPane.setSelectedIndex(deletedKey - 1);
        } else {
            this.tabbedPane.setSelectedIndex(deletedKey);
        }
        int tabIndex = 0;
        for (ConsoleTabView view : this.tabList) {
            view.setTabIndex(tabIndex);
            ++tabIndex;
        }
    }

    @Override
    public void enableNewTab(boolean state) {
    }

    @Override
    public NewTabView getNewTabView() {
        return this.newTabView;
    }

    @Override
    public ConsoleTabView getCurrentTabView() {
        return this.tabList.get(this.tabbedPane.getSelectedIndex());
    }

    public IHelp getConsoleHelpListener() {
        return this.consoleHelpListener;
    }
}

