/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import com.intel.stl.ui.console.IConsoleListener;
import com.intel.stl.ui.console.IConsoleLogin;
import com.intel.stl.ui.console.ITabListener;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.console.view.ConsoleLoginView;
import com.intel.stl.ui.console.view.IConsoleLoginListener;
import com.intel.stl.ui.console.view.IntelTerminalView;
import com.intel.stl.ui.console.view.TerminalCardView;
import com.intel.stl.ui.main.view.IFabricView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class ConsoleTerminalView
extends JPanel
implements IConsoleLoginListener {
    private static final long serialVersionUID = 4230538658726413678L;
    private JPanel serverInfoPanel;
    private JLabel lblHostValue;
    private JLabel lblPortValue;
    private JLabel lblUserValue;
    private JButton btnLock;
    private JComboBox<String> boxCommand;
    private JButton btnSend;
    private JPanel optionPanel;
    private JRadioButton rbtnCurrentTab;
    private JRadioButton rbtnNewTab;
    private TerminalCardView terminalCardView;
    private String hostName = new String("");
    private String portNum = new String("");
    private String userName = new String("");
    private LoginBean loginBean;
    private IConsoleListener consoleListener;
    private final ITabListener tabListener;
    private JPanel pnlControl;
    private final IFabricView owner;
    private ConsoleLoginView loginView;

    public ConsoleTerminalView(IFabricView owner, ITabListener tabListener) {
        this.owner = owner;
        this.tabListener = tabListener;
        this.initComponents();
        this.createButtonGroup();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        JPanel pnlInfo = new JPanel();
        pnlInfo.setLayout(new BorderLayout(0, 0));
        this.loginView = new ConsoleLoginView(this, this.tabListener);
        pnlInfo.add((Component)this.loginView, "North");
        this.pnlControl = this.getControlPanel();
        pnlInfo.add((Component)this.pnlControl, "Center");
        this.add((Component)pnlInfo, "North");
        this.terminalCardView = new TerminalCardView(STLConstants.K2107_ADM_CONSOLE.getValue());
        this.add((Component)this.terminalCardView, "Center");
    }

    public void enableHelp(boolean b) {
        this.terminalCardView.enableHelp(b);
    }

    public JButton getHelpButton() {
        return this.terminalCardView.getHelpButton();
    }

    protected JPanel getControlPanel() {
        JPanel ctrPanel = new JPanel();
        ctrPanel = new JPanel(new GridBagLayout());
        ctrPanel.setBorder(BorderFactory.createTitledBorder((String)null));
        ctrPanel.setBackground(UIConstants.INTEL_WHITE);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(1, 10, 3, 5);
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        JLabel server = ComponentFactory.getH4Label(STLConstants.K1053_SERVER_INFO.getValue(), 1);
        ctrPanel.add((Component)server, gc);
        gc.weightx = 1.0;
        JPanel serverInfo = this.getServerInfoPanel();
        ctrPanel.add((Component)serverInfo, gc);
        gc.weightx = 0.0;
        gc.gridwidth = 0;
        this.btnLock = ComponentFactory.getIntelDeleteButton(STLConstants.K1051_LOCK.getValue());
        this.btnLock.setSelected(true);
        this.btnLock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = ConsoleTerminalView.this.btnLock.isSelected();
                if (isSelected) {
                    ConsoleTerminalView.this.consoleListener.onLock(isSelected);
                    ConsoleTerminalView.this.toggleLock(!isSelected);
                    ConsoleTerminalView.this.consoleListener.hideLoginPanel();
                } else {
                    ConsoleTerminalView.this.consoleListener.showLoginPanel();
                }
                ConsoleTerminalView.this.btnLock.setSelected(!isSelected);
                if (isSelected) {
                    ConsoleTerminalView.this.btnLock.setText(STLConstants.K1052_UNLOCK.getValue());
                } else {
                    ConsoleTerminalView.this.btnLock.setText(STLConstants.K1051_LOCK.getValue());
                }
            }
        });
        this.btnLock.setName(WidgetName.ADMIN_CONSOLE_LOCK.name());
        ctrPanel.add((Component)this.btnLock, gc);
        gc.insets = new Insets(2, 10, 3, 5);
        gc.gridwidth = 1;
        JLabel cmd = ComponentFactory.getH4Label(STLConstants.K1044_COMMAND_TITLE.getValue(), 1);
        ctrPanel.add((Component)cmd, gc);
        gc.weightx = 1.0;
        this.boxCommand = new JComboBox();
        this.boxCommand.setUI(new IntelComboBoxUI());
        this.boxCommand.setEditable(true);
        AutoCompleteDecorator.decorate(this.boxCommand);
        this.boxCommand.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyChar() == '\n') {
                    ConsoleTerminalView.this.commandSendAction();
                }
            }
        });
        this.boxCommand.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                String entry = ((JTextField)ConsoleTerminalView.this.boxCommand.getEditor().getEditorComponent()).getText();
                if (entry.startsWith("iba_report -o ")) {
                    entry = "iba_report -reporttypes";
                }
                if (!entry.isEmpty()) {
                    ConsoleTerminalView.this.consoleListener.getHelpController().parseCommand(entry);
                    if (entry.split(" ").length > 0) {
                        ConsoleTerminalView.this.consoleListener.getHelpController().updateSelection(entry.split(" ")[0]);
                    }
                    ConsoleTerminalView.this.consoleListener.setLastCommand(entry);
                }
            }
        });
        this.boxCommand.setName(WidgetName.ADMIN_CONSOLE_COMMAND_BOX.name());
        ctrPanel.add(this.boxCommand, gc);
        gc.weightx = 0.0;
        gc.gridwidth = 0;
        this.btnSend = ComponentFactory.getIntelActionButton(STLConstants.K1045_SEND.getValue());
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleTerminalView.this.commandSendAction();
            }
        });
        this.btnSend.setName(WidgetName.ADMIN_CONSOLE_SEND.name());
        ctrPanel.add((Component)this.btnSend, gc);
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        JPanel optionPanel = this.getOptionPanel();
        ctrPanel.add((Component)optionPanel, gc);
        return ctrPanel;
    }

    protected JPanel getServerInfoPanel() {
        if (this.serverInfoPanel == null) {
            this.serverInfoPanel = new JPanel(new GridBagLayout());
            this.serverInfoPanel.setOpaque(false);
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.insets = new Insets(1, 2, 2, 2);
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            JLabel lblHost = ComponentFactory.getH4Label(STLConstants.K0051_HOST.getValue() + ": ", 0);
            this.serverInfoPanel.add((Component)lblHost, gc);
            gc.weightx = 1.0;
            this.lblHostValue = ComponentFactory.getH4Label("N/A", 2);
            this.lblHostValue.setName(WidgetName.ADMIN_CONSOLE_TERMINAL_HOST.name());
            this.serverInfoPanel.add((Component)this.lblHostValue, gc);
            gc.weightx = 0.0;
            JLabel lblPort = ComponentFactory.getH4Label(STLConstants.K1035_CONFIGURATION_PORT.getValue() + ": ", 0);
            this.serverInfoPanel.add((Component)lblPort, gc);
            gc.weightx = 1.0;
            this.lblPortValue = ComponentFactory.getH4Label("N/A", 2);
            this.lblPortValue.setName(WidgetName.ADMIN_CONSOLE_TERMINAL_PORT.name());
            this.serverInfoPanel.add((Component)this.lblPortValue, gc);
            gc.weightx = 0.0;
            JLabel lblUser = ComponentFactory.getH4Label(STLConstants.K0602_USER_NAME.getValue() + ": ", 0);
            this.serverInfoPanel.add((Component)lblUser, gc);
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            this.lblUserValue = ComponentFactory.getH4Label("N/A", 2);
            this.lblUserValue.setName(WidgetName.ADMIN_CONSOLE_TERMINAL_USERNAME.name());
            this.serverInfoPanel.add((Component)this.lblUserValue, gc);
        }
        return this.serverInfoPanel;
    }

    protected JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = new JPanel(new FlowLayout(4, 5, 0));
            this.optionPanel.setOpaque(false);
            this.rbtnCurrentTab = new JRadioButton(STLConstants.K1046_CURRENT_TAB.getValue());
            this.rbtnCurrentTab.setOpaque(false);
            this.rbtnCurrentTab.setFont(UIConstants.H5_FONT);
            this.rbtnCurrentTab.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.rbtnCurrentTab.setName(WidgetName.ADMIN_CONSOLE_CURRENT_TAB.name());
            this.rbtnCurrentTab.setSelected(true);
            this.optionPanel.add(this.rbtnCurrentTab);
            this.rbtnNewTab = new JRadioButton(STLConstants.K1047_NEW_TAB.getValue());
            this.rbtnNewTab.setOpaque(false);
            this.rbtnNewTab.setFont(UIConstants.H5_FONT);
            this.rbtnNewTab.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.rbtnNewTab.setName(WidgetName.ADMIN_CONSOLE_NEW_TAB.name());
            this.rbtnNewTab.setSelected(false);
            this.optionPanel.add(this.rbtnNewTab);
        }
        return this.optionPanel;
    }

    protected void commandSendAction() {
        String command = (String)this.boxCommand.getSelectedItem();
        if (command != null && command.length() != 0) {
            this.addCommand(command);
            this.boxCommand.getEditor().selectAll();
            if (this.isCurrentTabSelected()) {
                this.consoleListener.addToQueue(command);
                this.consoleListener.updatePersonalizedTab(command);
            } else if (this.isNewTabSelected()) {
                if (this.consoleListener.isConsoleAllowed()) {
                    this.consoleListener.addNewConsole(command);
                    this.boxCommand.setSelectedIndex(-1);
                    this.rbtnNewTab.setSelected(false);
                    this.rbtnCurrentTab.setSelected(true);
                } else {
                    Util.showErrorMessage(this, UILabels.STL80009_MAX_CHANNELS_IN_SESSION.getDescription(10));
                }
            }
            this.boxCommand.getEditor().setItem("");
        }
    }

    public void addCommand(String cmd) {
        for (int i = 0; i < this.boxCommand.getItemCount(); ++i) {
            String history = this.boxCommand.getItemAt(i);
            if (!cmd.equals(history)) continue;
            return;
        }
        this.boxCommand.addItem(cmd);
    }

    public void setCmdFieldEnable(boolean enable) {
        this.boxCommand.setEnabled(enable);
    }

    protected void createButtonGroup() {
        ButtonGroup rbtnGroup = new ButtonGroup();
        rbtnGroup.add(this.rbtnCurrentTab);
        rbtnGroup.add(this.rbtnNewTab);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.lblHostValue.setText(hostName);
    }

    public String getPortNum() {
        return this.portNum;
    }

    public void setPortNum(String portNum) {
        this.portNum = portNum;
        this.lblPortValue.setText(portNum);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.lblUserValue.setText(userName);
    }

    public void setTermPanel(IntelTerminalView panel) {
        this.terminalCardView.setTermPanel(panel);
    }

    public void displayMaxConsoles(boolean enable) {
        this.terminalCardView.displayMaxConsoles(enable);
    }

    public void setConsoleListener(IConsoleListener listener) {
        this.consoleListener = listener;
    }

    public boolean isCurrentTabSelected() {
        return this.rbtnCurrentTab.isSelected();
    }

    public boolean isNewTabSelected() {
        return this.rbtnNewTab.isSelected();
    }

    public void setFocus() {
        this.boxCommand.requestFocus();
    }

    public void enableCommanding(boolean enable) {
        this.boxCommand.setEnabled(enable);
        this.btnSend.setEnabled(enable);
    }

    public void enableNewTab(boolean enable) {
        this.rbtnNewTab.setEnabled(enable);
    }

    public IConsoleLogin getConsoleLogin() {
        return this.loginView;
    }

    public LoginBean getLoginBean() {
        return this.loginBean;
    }

    public void setLoginBean(LoginBean loginBean) {
        this.loginBean = loginBean;
    }

    public Object[] getPassword(String username) {
        JPasswordField pwdFld = new JPasswordField();
        int result = JOptionPane.showConfirmDialog((Component)((Object)this.owner), new Object[]{STLConstants.K1065_ENTER_PASSWORD.getValue() + " " + this.userName, pwdFld}, STLConstants.K1064_SESSION_AUTHENTICATION.getValue(), 2);
        String password = new String(pwdFld.getPassword());
        return new Object[]{result, password};
    }

    public void toggleLock(boolean isSelected) {
        this.terminalCardView.setLocked(!isSelected);
        this.btnSend.setEnabled(isSelected);
        this.boxCommand.setEnabled(isSelected);
        this.consoleListener.getTerminal().enableKeyHandler(isSelected);
        if (!isSelected) {
            this.btnLock.setText(STLConstants.K1052_UNLOCK.getValue());
        } else {
            this.btnLock.setText(STLConstants.K1051_LOCK.getValue());
        }
        this.btnLock.setSelected(isSelected);
    }

    @Override
    public void updateUIComponents(boolean state) {
        if (this.loginView.isVisible()) {
            this.btnLock.setEnabled(state);
        } else {
            this.btnLock.setEnabled(true);
        }
    }

    @Override
    public void enableLock(boolean state) {
        this.btnLock.setSelected(state);
        this.toggleLock(state);
    }

    @Override
    public int getControlPanelWidth() {
        return this.pnlControl.getPreferredSize().width;
    }
}

