/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.console.IConsoleEventListener;
import com.intel.stl.ui.console.ITabListener;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.console.view.ConsoleTabView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewTabView
extends JPanel
implements ITabListener {
    private static final long serialVersionUID = 6934999496353209087L;
    private final IConsoleEventListener consoleEventListener;
    private JLabel lblPlus;
    private final LoginBean defaultLoginBean;

    public NewTabView(LoginBean defaultLoginBean, IConsoleEventListener consoleEventListener) {
        this.defaultLoginBean = defaultLoginBean;
        this.consoleEventListener = consoleEventListener;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIConstants.INTEL_BLUE);
        this.lblPlus = ComponentFactory.getH2Label("+", 0);
        this.lblPlus.setBackground(UIConstants.INTEL_BLUE);
        this.lblPlus.setForeground(UIConstants.INTEL_WHITE);
        this.add((Component)this.lblPlus, "Center");
        this.addPlusLabelMouseListener();
    }

    protected void addPlusLabelMouseListener() {
        this.lblPlus.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewTabView.this.consoleEventListener.addNewConsole(NewTabView.this.defaultLoginBean, true, "");
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                NewTabView.this.lblPlus.setForeground(UIConstants.INTEL_RED);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NewTabView.this.lblPlus.setForeground(UIConstants.INTEL_WHITE);
            }
        });
    }

    @Override
    public void closeConsole(ConsoleTabView tabView) {
    }

    @Override
    public void enableNewTab(boolean enabled) {
        this.lblPlus.setEnabled(enabled);
    }

    @Override
    public NewTabView getNewTabView() {
        return this;
    }

    @Override
    public ConsoleTabView getCurrentTabView() {
        return null;
    }
}

