/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.email;

import com.intel.stl.api.configuration.MailProperties;
import com.intel.stl.api.notice.IEmailEventListener;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.email.IEmailController;
import com.intel.stl.ui.email.view.EmailSettingsView;
import com.intel.stl.ui.main.ISubnetManager;
import com.intel.stl.ui.main.view.FVMainFrame;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class EmailSettingsController
implements IEmailController,
IEmailEventListener<NoticeBean> {
    private static EmailSettingsController instance = null;
    private final EmailSettingsView view;
    private final ISubnetManager subnetMgr;
    private String smtpServerName = "";
    private String smtpPortNumber = new Integer(25).toString();
    private String fromAddress = "";
    private final String toTestAddress = "";
    private boolean isEmailNotificationsEnabled = false;

    private EmailSettingsController(EmailSettingsView view, ISubnetManager subnetMgr) {
        this.view = view;
        this.view.setEmailSettingsListener(this);
        this.subnetMgr = subnetMgr;
        subnetMgr.getConfigurationApi().addEmailEventListener(this);
        this.getSmtpSettingsFromDb();
        this.setSmtpSettingsInView();
    }

    private void setSmtpSettingsInView() {
        this.view.setSmtpServerNameStr(this.smtpServerName);
        this.view.setSmtpServerPortStr(this.smtpPortNumber);
        this.view.setFromAddrStr(this.fromAddress);
        this.view.setEnableEmailChkbox(this.isEmailNotificationsEnabled);
    }

    private void getSmtpSettingsFromDb() {
        MailProperties mailProperties = this.subnetMgr.getConfigurationApi().getMailProperties();
        this.smtpServerName = mailProperties.getSmtpServer();
        int port = mailProperties.getSmtpPort();
        if (port < 0) {
            port = 25;
        }
        this.smtpPortNumber = new Integer(port).toString();
        this.fromAddress = mailProperties.getFromAddr();
        this.isEmailNotificationsEnabled = mailProperties.getEmailNotificationsEnabled();
    }

    public static EmailSettingsController getInstance(FVMainFrame owner, ISubnetManager subMgr) {
        if (instance == null) {
            instance = new EmailSettingsController(new EmailSettingsView(owner), subMgr);
        } else {
            instance.updateOwner(owner);
        }
        return instance;
    }

    private void updateOwner(FVMainFrame owner) {
        this.view.setOwner(owner);
    }

    @Override
    public void onReset() {
        this.setSmtpSettingsInView();
    }

    @Override
    public void onOK() {
        this.smtpServerName = this.view.getSmtpServerNameStr();
        this.smtpPortNumber = this.view.getSmtpServerPortStr();
        this.fromAddress = this.view.getFromAddrStr();
        this.isEmailNotificationsEnabled = this.view.getEnableEmail();
        MailProperties mailProperties = new MailProperties();
        mailProperties.setSmtpServer(this.smtpServerName);
        mailProperties.setFromAddr(this.fromAddress);
        mailProperties.setSmtpPort(new Integer(this.smtpPortNumber));
        mailProperties.setEmailNotificationsEnabled(this.isEmailNotificationsEnabled);
        this.subnetMgr.getConfigurationApi().updateMailProperties(mailProperties);
    }

    @Override
    public void onTest() {
        this.view.showTesting(true);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                String testSmtpHostName = EmailSettingsController.this.view.getSmtpServerNameStr();
                String testSmtpPortNum = EmailSettingsController.this.view.getSmtpServerPortStr();
                String testToAddr = EmailSettingsController.this.view.getToAddrStr();
                String testFromAddr = EmailSettingsController.this.view.getFromAddrStr();
                MailProperties mailProperties = new MailProperties();
                mailProperties.setSmtpServer(testSmtpHostName);
                mailProperties.setFromAddr(testFromAddr);
                mailProperties.setSmtpPort(new Integer(testSmtpPortNum));
                String subject = UILabels.STL92001_TEST_EMAIL_SUBJECT.getDescription();
                String body = "";
                EmailSettingsController.this.subnetMgr.getConfigurationApi().sendTestMail(mailProperties, testToAddr, subject, body);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    Util.showError(EmailSettingsController.this.view, e);
                }
                finally {
                    EmailSettingsController.this.view.showTesting(false);
                }
            }
        };
        worker.execute();
    }

    @Override
    public void showEmailSettingsDlg(FVMainFrame owner) {
        this.view.setOwner(owner);
        this.view.setLocationRelativeTo(owner);
        this.view.setVisible(true);
        this.view.toFront();
    }

    @Override
    public void hideEmailSettingsDlg() {
        this.view.setVisible(false);
    }

    public void onNewEvent(NoticeBean[] noticeList) {
        for (NoticeBean bean : noticeList) {
            Util.showErrorMessage(this.view, new String(bean.getData()));
        }
    }

    @Override
    public boolean isEmailValid(String email) {
        return this.subnetMgr.isEmailValid(email);
    }
}

