/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.event;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.event.JumpToEvent;
import java.util.ArrayList;
import java.util.List;

public class NodesSelectedEvent
extends JumpToEvent {
    private final List<Item> nodes = new ArrayList<Item>();

    public NodesSelectedEvent(Object origin, String destination) {
        super(origin, destination);
    }

    public NodesSelectedEvent(int lid, NodeType type, Object origin, String destination) {
        super(origin, destination);
        this.addNode(lid, type);
    }

    public void addNode(int lid, NodeType type) {
        this.nodes.add(new Item(lid, type));
    }

    public int numberOfNodes() {
        return this.nodes.size();
    }

    public int getLid(int index) {
        return this.nodes.get(index).getLid();
    }

    public NodeType getType(int index) {
        return this.nodes.get(index).getType();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodesSelectedEvent other = (NodesSelectedEvent)obj;
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    @Override
    public String toString() {
        return "NodesSelectedEvent [nodes=" + this.nodes + ", destination=" + this.destination + "]";
    }

    protected static class Item {
        private final int lid;
        private final NodeType type;

        public Item(int lid, NodeType type) {
            this.lid = lid;
            this.type = type;
        }

        public int getLid() {
            return this.lid;
        }

        public NodeType getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.lid;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.lid != other.lid) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "Item [lid=" + this.lid + ", type=" + (Object)((Object)this.type) + "]";
        }
    }
}

