/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.event;

import com.intel.stl.ui.event.JumpToEvent;
import java.util.ArrayList;
import java.util.List;

public class PortsSelectedEvent
extends JumpToEvent {
    private final List<Item> ports = new ArrayList<Item>();

    public PortsSelectedEvent(Object origin, String destination) {
        super(origin, destination);
    }

    public PortsSelectedEvent(int lid, short portNum, Object origin, String destination) {
        super(origin, destination);
        this.addPort(lid, portNum);
    }

    public int numberOfPorts() {
        return this.ports.size();
    }

    public void addPort(int lid, short portNum) {
        this.ports.add(new Item(lid, portNum));
    }

    public int getLid(int index) {
        return this.ports.get(index).getLid();
    }

    public short getPortNum(int index) {
        return this.ports.get(index).getPortNum();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ports == null ? 0 : this.ports.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortsSelectedEvent other = (PortsSelectedEvent)obj;
        return !(this.ports == null ? other.ports != null : !this.ports.equals(other.ports));
    }

    @Override
    public String toString() {
        return "PortsSelectedEvent [ports=" + this.ports + "]";
    }

    protected static class Item {
        private final int lid;
        private final short portNum;

        public Item(int lid, short portNum) {
            this.lid = lid;
            this.portNum = portNum;
        }

        public int getLid() {
            return this.lid;
        }

        public short getPortNum() {
            return this.portNum;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.lid;
            result = 31 * result + this.portNum;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.lid != other.lid) {
                return false;
            }
            return this.portNum == other.portNum;
        }

        public String toString() {
            return "Item [lid=" + this.lid + ", portNum=" + this.portNum + "]";
        }
    }
}

