/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.framework;

import com.intel.stl.ui.framework.AbstractEvent;
import com.intel.stl.ui.framework.AbstractModel;
import com.intel.stl.ui.framework.AbstractView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.framework.IController;
import com.intel.stl.ui.framework.IModelListener;
import com.intel.stl.ui.framework.ITask;
import com.intel.stl.ui.main.Context;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.engio.mbassy.bus.MBassador;

public abstract class AbstractController<M extends AbstractModel, V extends AbstractView<M, C>, C extends AbstractController<M, V, C>>
implements IController {
    private final List<IModelListener<M>> listeners = new ArrayList<IModelListener<M>>();
    protected final M model;
    protected final V view;
    protected MBassador<IAppEvent> eventBus;
    private Context context;

    public AbstractController(M model, V view, MBassador<IAppEvent> eventBus) {
        this.model = model;
        this.view = view;
        this.eventBus = eventBus;
        ((AbstractView)view).setController(this.asController());
        ((AbstractView)view).initView();
        this.initModel();
        this.addModelListener((IModelListener<M>)view);
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public abstract void initModel();

    @Override
    public void submitTask(ITask task) {
        task.execute(this);
    }

    protected void fireEvent(AbstractEvent event) {
        this.eventBus.publish((Object)event);
    }

    @Override
    public void onTaskSuccess() {
        this.notifyModelChanged();
    }

    @Override
    public void onTaskFailure(Throwable caught) {
        this.notifyModelUpdateFailed(caught);
    }

    public C asController() {
        this.checkController();
        return (C)this;
    }

    public void addModelListener(IModelListener<M> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            this.notifyModelChanged(listener);
        }
    }

    public boolean removeModelListener(IModelListener<M> listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void notifyModelChanged() {
        for (IModelListener<M> listener : this.listeners) {
            this.notifyModelChanged(listener);
        }
    }

    @Override
    public void notifyModelUpdateFailed(Throwable caught) {
        for (IModelListener<M> listener : this.listeners) {
            this.notifyModelUpdateFailed(listener, caught);
        }
    }

    protected void notifyModelChanged(IModelListener<M> listener) {
        listener.modelChanged(this.model);
    }

    protected void notifyModelUpdateFailed(IModelListener<M> listener, Throwable caught) {
        listener.modelUpdateFailed(this.model, caught);
    }

    private void checkController() {
        Class expectedController;
        Class rawType;
        ParameterizedType parameterizedType;
        Type type = this.getClass();
        while (!AbstractController.class.equals(this.getClass(type))) {
            if (type instanceof Class) {
                if ((type = type.getGenericSuperclass()) != null) continue;
                break;
            }
            parameterizedType = (ParameterizedType)type;
            rawType = (Class)parameterizedType.getRawType();
            if (rawType.equals(AbstractController.class)) continue;
            type = rawType.getGenericSuperclass();
        }
        if (type != null && type instanceof ParameterizedType && (rawType = (Class)(parameterizedType = (ParameterizedType)type).getRawType()).equals(AbstractController.class) && !(expectedController = (Class)parameterizedType.getActualTypeArguments()[2]).isInstance(this)) {
            throw new IllegalArgumentException("This class does not correspond to the declared Controller type: " + expectedController.getSimpleName());
        }
    }

    private Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.getClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }
}

